/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.project;

import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class AndroidClasspathContainerPage
extends WizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private IProject mOwnerProject;
    private String mLibsProjectName;
    private Combo mProjectsCombo;
    private IStatus mCurrStatus = new StatusInfo();
    private boolean mPageVisible = false;

    public AndroidClasspathContainerPage() {
        super("AndroidClasspathContainerPage");
        this.setTitle("Android Libraries");
        this.setDescription("This container manages classpath entries for Android container");
    }

    public IClasspathEntry getSelection() {
        Path path = new Path("com.android.ide.eclipse.adt.ANDROID_FRAMEWORK");
        int index = this.mProjectsCombo.getSelectionIndex();
        if (index != -1) {
            String selectedProjectName = this.mProjectsCombo.getItem(index);
            if (this.mOwnerProject == null || !selectedProjectName.equals(this.mOwnerProject.getName())) {
                path = path.append(selectedProjectName);
            }
        }
        return JavaCore.newContainerEntry((IPath)path);
    }

    public void setSelection(IClasspathEntry cpentry) {
        IPath path;
        IPath iPath = path = cpentry == null ? null : cpentry.getPath();
        if (path == null || path.segmentCount() == 1) {
            if (this.mOwnerProject != null) {
                this.mLibsProjectName = this.mOwnerProject.getName();
            }
        } else {
            this.mLibsProjectName = path.segment(1);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText("Project:");
        String[] androidProjects = AndroidClasspathContainerPage.getAndroidProjects();
        this.mProjectsCombo = new Combo(composite, 8);
        this.mProjectsCombo.setItems(androidProjects);
        int index = this.mOwnerProject != null ? AndroidClasspathContainerPage.indexOf(androidProjects, this.mLibsProjectName) : (this.mProjectsCombo.getItemCount() > 0 ? 0 : -1);
        if (index != -1) {
            this.mProjectsCombo.select(index);
        }
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.minimumWidth = 100;
        this.mProjectsCombo.setLayoutData((Object)gd);
        this.setControl((Control)composite);
    }

    public boolean finish() {
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.mPageVisible = visible;
        if (visible && this.mCurrStatus.matches(4)) {
            StatusInfo status = new StatusInfo();
            status.setError("");
            this.mCurrStatus = status;
        }
        this.updateStatus(this.mCurrStatus);
    }

    protected void updateStatus(IStatus status) {
        this.mCurrStatus = status;
        this.setPageComplete(!status.matches(4));
        if (this.mPageVisible) {
            StatusUtil.applyToStatusLine((DialogPage)this, (IStatus)status);
        }
    }

    protected void updateStatus(IStatus[] status) {
        this.updateStatus(StatusUtil.getMostSevere((IStatus[])status));
    }

    public void initialize(IJavaProject project, IClasspathEntry[] currentEntries) {
        this.mOwnerProject = project == null ? null : project.getProject();
    }

    private static String[] getAndroidProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        Object[] names = new String[projects.length];
        int i = 0;
        while (i < projects.length) {
            names[i] = projects[i].getName();
            ++i;
        }
        Arrays.sort(names);
        return names;
    }

    private static int indexOf(String[] array, String str) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(str)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

