/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.project;

import com.android.ide.eclipse.adt.AdtPlugin;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class FolderDecorator
implements ILightweightLabelDecorator {
    private ImageDescriptor mDescriptor = AdtPlugin.getImageDescriptor("/icons/android_project.png");

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IFolder) {
            IFolder folder = (IFolder)element;
            IProject project = folder.getProject();
            if (project == null || !project.exists() || !folder.exists()) {
                return;
            }
            try {
                if (project.hasNature("com.android.ide.eclipse.adt.AndroidNature") && folder.getParent().getType() == 4) {
                    String name = folder.getName();
                    if (name.equals("assets")) {
                        this.doDecoration(decoration, null);
                    } else if (name.equals("res")) {
                        this.doDecoration(decoration, null);
                    } else if (name.equals("gen")) {
                        this.doDecoration(decoration, " [Generated Java Files]");
                    } else if (name.equals("libs")) {
                        this.doDecoration(decoration, null);
                    } else if (name.equals("bin")) {
                        this.doDecoration(decoration, null);
                    }
                }
            }
            catch (CoreException e) {
                AdtPlugin.log(e, "Unable to get nature of project '%s'.", project.getName());
            }
        }
    }

    public void doDecoration(IDecoration decoration, String suffix) {
        decoration.addOverlay(this.mDescriptor, 0);
        if (suffix != null) {
            decoration.addSuffix(suffix);
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }
}

