/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.properties;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.properties.LibraryProperties;
import com.android.ide.eclipse.adt.internal.sdk.ProjectState;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.project.ProjectPropertiesWorkingCopy;
import com.android.sdkuilib.internal.widgets.SdkTargetSelector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;

public class AndroidPropertyPage
extends PropertyPage {
    private IProject mProject;
    private SdkTargetSelector mSelector;
    private Button mIsLibrary;
    private LibraryProperties mLibraryDependencies;
    private ProjectPropertiesWorkingCopy mPropertiesWorkingCopy;

    protected Control createContents(Composite parent) {
        this.mProject = (IProject)this.getElement();
        IAndroidTarget[] targets = null;
        if (Sdk.getCurrent() != null) {
            targets = Sdk.getCurrent().getTargets();
        }
        Composite top = new Composite(parent, 0);
        top.setLayoutData((Object)new GridData(1808));
        top.setLayout((Layout)new GridLayout(1, false));
        Group targetGroup = new Group(top, 0);
        targetGroup.setLayoutData((Object)new GridData(1808));
        targetGroup.setLayout((Layout)new GridLayout(1, false));
        targetGroup.setText("Project Build Target");
        this.mSelector = new SdkTargetSelector((Composite)targetGroup, targets);
        Group libraryGroup = new Group(top, 0);
        libraryGroup.setLayoutData((Object)new GridData(1808));
        libraryGroup.setLayout((Layout)new GridLayout(1, false));
        libraryGroup.setText("Library");
        this.mIsLibrary = new Button((Composite)libraryGroup, 32);
        this.mIsLibrary.setText("Is Library");
        this.mLibraryDependencies = new LibraryProperties((Composite)libraryGroup);
        this.fillUi();
        this.mSelector.setSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AndroidPropertyPage.this.updateValidity();
            }
        });
        this.mProject.isOpen();
        return top;
    }

    public boolean performOk() {
        Sdk currentSdk = Sdk.getCurrent();
        if (currentSdk != null && this.mProject.isOpen()) {
            ProjectState state = Sdk.getProjectState(this.mProject);
            boolean mustSaveProp = false;
            IAndroidTarget newTarget = this.mSelector.getSelected();
            if (state == null || newTarget != state.getTarget()) {
                this.mPropertiesWorkingCopy.setProperty("target", newTarget.hashString());
                mustSaveProp = true;
            }
            if (state == null || this.mIsLibrary.getSelection() != state.isLibrary()) {
                this.mPropertiesWorkingCopy.setProperty("android.library", Boolean.toString(this.mIsLibrary.getSelection()));
                mustSaveProp = true;
            }
            if (this.mLibraryDependencies.save()) {
                mustSaveProp = true;
            }
            if (mustSaveProp) {
                try {
                    this.mPropertiesWorkingCopy.save();
                    IResource projectProp = this.mProject.findMember("project.properties");
                    if (projectProp != null) {
                        projectProp.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                catch (Exception e) {
                    String msg = String.format("Failed to save %1$s for project %2$s", "project.properties", this.mProject.getName());
                    AdtPlugin.log(e, msg, new Object[0]);
                }
            }
        }
        return true;
    }

    protected void performDefaults() {
        this.fillUi();
        this.updateValidity();
    }

    private void fillUi() {
        if (Sdk.getCurrent() != null && this.mProject.isOpen()) {
            ProjectState state = Sdk.getProjectState(this.mProject);
            this.mPropertiesWorkingCopy = state.getProperties().makeWorkingCopy();
            IAndroidTarget target = state.getTarget();
            if (target != null) {
                this.mSelector.setSelection(target);
            }
            this.mIsLibrary.setSelection(state.isLibrary());
            this.mLibraryDependencies.setContent(state, this.mPropertiesWorkingCopy);
        }
    }

    private void updateValidity() {
        IAndroidTarget target = this.mSelector.getSelected();
        this.setValid(target != null);
    }
}

