/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.sdk;

import com.android.ide.common.resources.platform.AttrsXmlParser;
import com.android.ide.common.resources.platform.ViewClassInfo;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.sdk.IAndroidClassLoader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.management.InvalidAttributeValueException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class LayoutParamsParser {
    protected IAndroidClassLoader.IClassDescriptor mTopViewClass;
    protected IAndroidClassLoader.IClassDescriptor mTopGroupClass;
    protected IAndroidClassLoader.IClassDescriptor mTopLayoutParamsClass;
    protected ArrayList<IAndroidClassLoader.IClassDescriptor> mViewList;
    protected ArrayList<IAndroidClassLoader.IClassDescriptor> mGroupList;
    protected TreeMap<String, ExtViewClassInfo> mViewMap;
    protected TreeMap<String, ExtViewClassInfo> mGroupMap;
    protected HashMap<String, ViewClassInfo.LayoutParamsInfo> mLayoutParamsMap;
    protected AttrsXmlParser mAttrsXmlParser;
    protected IAndroidClassLoader mClassLoader;

    public LayoutParamsParser(IAndroidClassLoader classLoader, AttrsXmlParser attrsXmlParser) {
        this.mClassLoader = classLoader;
        this.mAttrsXmlParser = attrsXmlParser;
    }

    public List<ViewClassInfo> getViews() {
        return this.getInstantiables(this.mViewMap);
    }

    public List<ViewClassInfo> getGroups() {
        return this.getInstantiables(this.mGroupMap);
    }

    public void parseLayoutClasses(IProgressMonitor monitor) {
        this.parseClasses(monitor, "android.view.View", "android.view.ViewGroup", "android.view.ViewGroup$LayoutParams");
    }

    public void parsePreferencesClasses(IProgressMonitor monitor) {
        this.parseClasses(monitor, "android.preference.Preference", "android.preference.PreferenceGroup", null);
    }

    private void parseClasses(IProgressMonitor monitor, String rootClassName, String groupClassName, String paramsClassName) {
        try {
            ExtViewClassInfo vg;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            String[] superClasses = new String[2 + (paramsClassName == null ? 0 : 1)];
            superClasses[0] = groupClassName;
            superClasses[1] = rootClassName;
            if (paramsClassName != null) {
                superClasses[2] = paramsClassName;
            }
            HashMap<String, ArrayList<IAndroidClassLoader.IClassDescriptor>> found = this.mClassLoader.findClassesDerivingFrom("android.", superClasses);
            this.mTopViewClass = this.mClassLoader.getClass(rootClassName);
            this.mTopGroupClass = this.mClassLoader.getClass(groupClassName);
            if (paramsClassName != null) {
                this.mTopLayoutParamsClass = this.mClassLoader.getClass(paramsClassName);
            }
            this.mViewList = found.get(rootClassName);
            this.mGroupList = found.get(groupClassName);
            this.mViewMap = new TreeMap();
            this.mGroupMap = new TreeMap();
            if (this.mTopLayoutParamsClass != null) {
                this.mLayoutParamsMap = new HashMap();
            }
            if (this.mTopGroupClass != null) {
                this.addGroup(this.mTopGroupClass);
            }
            if (this.mTopViewClass != null) {
                this.addView(this.mTopViewClass);
            }
            if ((vg = this.mGroupMap.get(groupClassName)) != null) {
                vg.setSuperClass(this.mViewMap.get(rootClassName));
            }
            progress.setWorkRemaining(this.mGroupList.size() + this.mViewList.size());
            for (IAndroidClassLoader.IClassDescriptor groupChild : this.mGroupList) {
                this.addGroup(groupChild);
                progress.worked(1);
            }
            for (IAndroidClassLoader.IClassDescriptor viewChild : this.mViewList) {
                if (viewChild != this.mTopGroupClass) {
                    this.addView(viewChild);
                }
                progress.worked(1);
            }
        }
        catch (ClassNotFoundException e) {
            AdtPlugin.log(e, "Problem loading class %1$s or %2$s", rootClassName, groupClassName);
        }
        catch (InvalidAttributeValueException e) {
            AdtPlugin.log(e, "Problem loading classes", new Object[0]);
        }
        catch (ClassFormatError e) {
            AdtPlugin.log(e, "Problem loading classes", new Object[0]);
        }
        catch (IOException e) {
            AdtPlugin.log(e, "Problem loading classes", new Object[0]);
        }
    }

    private ExtViewClassInfo addView(IAndroidClassLoader.IClassDescriptor viewClass) {
        String fqcn = viewClass.getFullClassName();
        if (this.mViewMap.containsKey(fqcn)) {
            return this.mViewMap.get(fqcn);
        }
        if (this.mGroupMap.containsKey(fqcn)) {
            return this.mGroupMap.get(fqcn);
        }
        ExtViewClassInfo info = new ExtViewClassInfo(viewClass.isInstantiable(), false, fqcn, viewClass.getSimpleName());
        this.mViewMap.put(fqcn, info);
        if (!viewClass.equals(this.mTopViewClass)) {
            IAndroidClassLoader.IClassDescriptor superClass = viewClass.getSuperclass();
            ExtViewClassInfo superClassInfo = this.addView(superClass);
            info.setSuperClass(superClassInfo);
        }
        this.mAttrsXmlParser.loadViewAttributes(info);
        return info;
    }

    private ExtViewClassInfo addGroup(IAndroidClassLoader.IClassDescriptor groupClass) {
        ExtViewClassInfo superClassInfo;
        String fqcn = groupClass.getFullClassName();
        if (this.mGroupMap.containsKey(fqcn)) {
            return this.mGroupMap.get(fqcn);
        }
        ExtViewClassInfo info = new ExtViewClassInfo(groupClass.isInstantiable(), true, fqcn, groupClass.getSimpleName());
        this.mGroupMap.put(fqcn, info);
        IAndroidClassLoader.IClassDescriptor superClass = groupClass.getSuperclass();
        if (superClass != null && !superClass.equals(this.mTopViewClass) && (superClassInfo = this.addGroup(superClass)) != null && superClassInfo != info) {
            info.setSuperClass(superClassInfo);
        }
        this.mAttrsXmlParser.loadViewAttributes(info);
        if (this.mTopLayoutParamsClass != null) {
            info.setLayoutParams(this.addLayoutParams(groupClass));
        }
        return info;
    }

    private ViewClassInfo.LayoutParamsInfo addLayoutParams(IAndroidClassLoader.IClassDescriptor groupClass) {
        IAndroidClassLoader.IClassDescriptor layoutParamsClass = this.findLayoutParams(groupClass);
        if (layoutParamsClass == null) {
            IAndroidClassLoader.IClassDescriptor superClass = groupClass.getSuperclass();
            while (layoutParamsClass == null && superClass != null && !superClass.equals(this.mTopViewClass)) {
                layoutParamsClass = this.findLayoutParams(superClass);
                superClass = superClass.getSuperclass();
            }
        }
        if (layoutParamsClass != null) {
            return this.getLayoutParamsInfo(layoutParamsClass);
        }
        return null;
    }

    private ViewClassInfo.LayoutParamsInfo getLayoutParamsInfo(IAndroidClassLoader.IClassDescriptor layoutParamsClass) {
        String fqcn = layoutParamsClass.getFullClassName();
        ViewClassInfo.LayoutParamsInfo layoutParamsInfo = this.mLayoutParamsMap.get(fqcn);
        if (layoutParamsInfo != null) {
            return layoutParamsInfo;
        }
        ViewClassInfo.LayoutParamsInfo superClassInfo = null;
        if (!layoutParamsClass.equals(this.mTopLayoutParamsClass)) {
            IAndroidClassLoader.IClassDescriptor superClass = layoutParamsClass.getSuperclass();
            superClassInfo = this.getLayoutParamsInfo(superClass);
        }
        ExtViewClassInfo enclosingGroupInfo = this.addGroup(layoutParamsClass.getEnclosingClass());
        layoutParamsInfo = new ViewClassInfo.LayoutParamsInfo(enclosingGroupInfo, layoutParamsClass.getSimpleName(), superClassInfo);
        this.mLayoutParamsMap.put(fqcn, layoutParamsInfo);
        this.mAttrsXmlParser.loadLayoutParamsAttributes(layoutParamsInfo);
        return layoutParamsInfo;
    }

    private IAndroidClassLoader.IClassDescriptor findLayoutParams(IAndroidClassLoader.IClassDescriptor groupClass) {
        IAndroidClassLoader.IClassDescriptor[] innerClasses;
        IAndroidClassLoader.IClassDescriptor[] iClassDescriptorArray = innerClasses = groupClass.getDeclaredClasses();
        int n = innerClasses.length;
        int n2 = 0;
        while (n2 < n) {
            IAndroidClassLoader.IClassDescriptor innerClass = iClassDescriptorArray[n2];
            if (innerClass.getSimpleName().equals("LayoutParams")) {
                return innerClass;
            }
            ++n2;
        }
        return null;
    }

    private List<ViewClassInfo> getInstantiables(SortedMap<String, ExtViewClassInfo> map) {
        Collection<ExtViewClassInfo> values = map.values();
        ArrayList<ViewClassInfo> list = new ArrayList<ViewClassInfo>();
        for (ExtViewClassInfo info : values) {
            if (!info.isInstantiable()) continue;
            list.add(info);
        }
        return list;
    }

    static final class ExtViewClassInfo
    extends ViewClassInfo {
        private boolean mIsInstantiable;

        ExtViewClassInfo(boolean instantiable, boolean isLayout, String canonicalClassName, String shortClassName) {
            super(isLayout, canonicalClassName, shortClassName);
            this.mIsInstantiable = instantiable;
        }

        boolean isInstantiable() {
            return this.mIsInstantiable;
        }
    }
}

