/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.welcome;

import java.net.URL;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;

public class UsagePermissionPage
extends WizardPage
implements SelectionListener {
    private Link mLink;
    private Button mYesRadio;
    private Button mNoRadio;

    public UsagePermissionPage() {
        super("usageData");
        this.setTitle("Contribute Usage Statistics?");
        this.setDescription("We know you just want to get started but please read this first.");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(container, 64);
        GridData gd_lblByChoosingTo = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_lblByChoosingTo.widthHint = 580;
        label.setLayoutData((Object)gd_lblByChoosingTo);
        label.setText("By choosing to send certain usage statistics to Google, you can help us improve the Android SDK. These usage statistics lets us measure things like active usage of the SDK, and let us know things like which versions of the SDK are in use and which tools are the most popular with developers. This limited data is not associated with personal information about you, and is examined on an aggregate basis, and is maintained in accordance with the Google Privacy Policy.");
        new Label(container, 0);
        Label questionLabel = new Label(container, 0);
        questionLabel.setText("Send usage statistics to Google?");
        this.mYesRadio = new Button(container, 16);
        this.mYesRadio.setText("Yes");
        this.mYesRadio.addSelectionListener((SelectionListener)this);
        this.mNoRadio = new Button(container, 16);
        this.mNoRadio.setText("No");
        this.mNoRadio.addSelectionListener((SelectionListener)this);
        Label laterLabel = new Label(container, 64);
        GridData gdLaterLabel = new GridData(4, 1024, false, true, 1, 1);
        gdLaterLabel.widthHint = 580;
        laterLabel.setLayoutData((Object)gdLaterLabel);
        laterLabel.setText("If you later decide to change this setting, you can do so in the options panel under Android > Usage Stats");
        this.mLink = new Link(container, 0);
        this.mLink.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.mLink.setText("<a href=\"http://www.google.com/intl/en/privacy.html\">Google Privacy Policy</a>");
        this.mLink.addSelectionListener((SelectionListener)this);
        this.validatePage();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.mYesRadio.setFocus();
    }

    boolean isUsageCollectionApproved() {
        return this.mYesRadio.getSelection();
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.getSource() == this.mLink) {
            try {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWebBrowser browser = workbench.getBrowserSupport().getExternalBrowser();
                browser.openURL(new URL(event.text));
            }
            catch (Exception exception) {
                String message = String.format("Could not open browser. Vist\n%1$s\ninstead.", event.text);
                MessageDialog.openError((Shell)this.getWizard().getContainer().getShell(), (String)"Browser Error", (String)message);
            }
        } else {
            this.validatePage();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void validatePage() {
        String error = null;
        if (!this.mYesRadio.getSelection() && !this.mNoRadio.getSelection()) {
            error = "Select Yes or No";
        }
        this.setPageComplete(error == null);
        if (error != null) {
            this.setMessage(error, 3);
        } else {
            this.setErrorMessage(null);
            this.setMessage(null);
        }
    }
}

