/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.exportgradle;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.wizards.exportgradle.BuildFileCreator;
import com.android.ide.eclipse.adt.internal.wizards.exportgradle.ConfirmationPage;
import com.android.ide.eclipse.adt.internal.wizards.exportgradle.ExportMessages;
import com.android.ide.eclipse.adt.internal.wizards.exportgradle.FinalPage;
import com.android.ide.eclipse.adt.internal.wizards.exportgradle.GradleModule;
import com.android.ide.eclipse.adt.internal.wizards.exportgradle.ProjectSelectionPage;
import com.android.ide.eclipse.adt.internal.wizards.exportgradle.ProjectSetupBuilder;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class GradleExportWizard
extends Wizard
implements IExportWizard {
    private ProjectSetupBuilder mBuilder = new ProjectSetupBuilder();
    private ProjectSelectionPage mFirstPage;
    private ConfirmationPage mSecondPage;
    private FinalPage mFinalPage;

    public boolean performFinish() {
        if (this.mBuilder.canGenerate()) {
            this.generateBuildfiles(this.mSecondPage);
            this.getContainer().showPage((IWizardPage)this.mFinalPage);
            return false;
        }
        return true;
    }

    public void addPages() {
        this.mFirstPage = new ProjectSelectionPage(this.mBuilder);
        this.addPage((IWizardPage)this.mFirstPage);
        this.mSecondPage = new ConfirmationPage(this.mBuilder);
        this.addPage((IWizardPage)this.mSecondPage);
        this.mFinalPage = new FinalPage(this.mBuilder);
        this.addPage((IWizardPage)this.mFinalPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(ExportMessages.WindowTitle);
        this.setNeedsProgressMonitor(true);
    }

    public boolean canFinish() {
        return this.mBuilder.canFinish() || this.mBuilder.canGenerate();
    }

    public boolean generateBuildfiles(final WizardPage page) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InterruptedException {
                Collection<GradleModule> modules = GradleExportWizard.this.mBuilder.getModules();
                int count = modules.size();
                SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)pm, (String)ExportMessages.StatusMessage, (int)count);
                BuildFileCreator.createBuildFiles(GradleExportWizard.this.mBuilder, page.getShell(), (IProgressMonitor)localmonitor.newChild(count));
            }
        };
        try {
            this.getContainer().run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            AdtPlugin.log(e, null, new Object[0]);
            return false;
        }
        catch (InterruptedException e) {
            AdtPlugin.log(e, null, new Object[0]);
            return false;
        }
        return page.getErrorMessage() == null;
    }
}

