/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.newxmlfile;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.editors.AndroidXmlEditor;
import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DocumentDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.IDescriptorProvider;
import com.android.ide.eclipse.adt.internal.project.ProjectChooserHelper;
import com.android.ide.eclipse.adt.internal.resources.ResourceNameValidator;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.ide.eclipse.adt.internal.wizards.newxmlfile.NewXmlFileWizard;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.IAndroidTarget;
import com.android.utils.Pair;
import com.android.utils.SdkUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

class NewXmlFileCreationPage
extends WizardPage {
    private static final TypeInfo[] sTypes = new TypeInfo[]{new TypeInfo("Layout", "An XML file that describes a screen layout.", ResourceFolderType.LAYOUT, 2, "LinearLayout", "http://schemas.android.com/apk/res/android", "", 1){

        @Override
        String getDefaultRoot(IProject project) {
            return "LinearLayout";
        }

        @Override
        String getDefaultAttrs(IProject project, String root) {
            IAndroidTarget target;
            Sdk currentSdk = Sdk.getCurrent();
            String fill = "fill_parent";
            if (currentSdk != null && (target = currentSdk.getTarget(project)) != null && target.getVersion().getApiLevel() >= 8) {
                fill = "match_parent";
            }
            String size = String.format("android:layout_width=\"%1$s\"\nandroid:layout_height=\"%2$s\"", fill, fill);
            if ("LinearLayout".equals(root)) {
                return "android:orientation=\"vertical\"\n" + size;
            }
            return size;
        }

        @Override
        String getChild(IProject project, String root) {
            if ("ScrollView".equals(root) || "HorizontalScrollView".equals(root)) {
                return "    <LinearLayout " + this.getDefaultAttrs(project, root).replace('\n', ' ') + " android:orientation=\"vertical\"" + "></LinearLayout>\n";
            }
            return null;
        }
    }, new TypeInfo("Values", "An XML file with simple values: colors, strings, dimensions, etc.", ResourceFolderType.VALUES, "resources", null, null, null, 1), new TypeInfo("Drawable", "An XML file that describes a drawable.", ResourceFolderType.DRAWABLE, 9, null, "http://schemas.android.com/apk/res/android", null, 1), new TypeInfo("Menu", "An XML file that describes an menu.", ResourceFolderType.MENU, "menu", null, "http://schemas.android.com/apk/res/android", null, 1), new TypeInfo("Color List", "An XML file that describes a color state list.", ResourceFolderType.COLOR, 12, "selector", "http://schemas.android.com/apk/res/android", null, 1), new TypeInfo("Property Animation", "An XML file that describes a property animation", ResourceFolderType.ANIMATOR, 10, "set", "http://schemas.android.com/apk/res/android", null, 11), new TypeInfo("Tween Animation", "An XML file that describes a tween animation.", ResourceFolderType.ANIM, 11, "set", null, null, 1), new TypeInfo("AppWidget Provider", "An XML file that describes a widget provider.", ResourceFolderType.XML, 8, null, "http://schemas.android.com/apk/res/android", null, 3), new TypeInfo("Preference", "An XML file that describes preferences.", ResourceFolderType.XML, 7, "PreferenceScreen", "http://schemas.android.com/apk/res/android", null, 1), new TypeInfo("Searchable", "An XML file that describes a searchable.", ResourceFolderType.XML, 6, null, "http://schemas.android.com/apk/res/android", null, 1)};
    private NewXmlFileWizard.Values mValues;
    private ProjectChooserHelper.ProjectCombo mProjectButton;
    private Text mFileNameTextField;
    private Combo mTypeCombo;
    private IStructuredSelection mInitialSelection;
    private ResourceFolderType mInitialFolderType;
    private boolean mInternalTypeUpdate;
    private Sdk.TargetChangeListener mSdkTargetChangeListener;
    private Table mRootTable;
    private TableViewer mRootTableViewer;

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.mFileNameTextField != null) {
            this.mFileNameTextField.setFocus();
        }
        this.validatePage();
    }

    protected NewXmlFileCreationPage(String pageName, NewXmlFileWizard.Values values) {
        super(pageName);
        this.mValues = values;
        this.setPageComplete(false);
    }

    public void setInitialSelection(IStructuredSelection initialSelection) {
        this.mInitialSelection = initialSelection;
    }

    public void setInitialFolderType(ResourceFolderType initialType) {
        this.mInitialFolderType = initialType;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label typeLabel = new Label(composite, 0);
        typeLabel.setText("Resource Type:");
        this.mTypeCombo = new Combo(composite, 12);
        this.mTypeCombo.setToolTipText("What type of resource would you like to create?");
        this.mTypeCombo.setLayoutData((Object)new GridData(768));
        if (this.mInitialFolderType != null) {
            this.mTypeCombo.setEnabled(false);
        }
        this.mTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TypeInfo type = NewXmlFileCreationPage.this.getSelectedType();
                if (type != null) {
                    NewXmlFileCreationPage.this.onSelectType(type);
                }
            }
        });
        Label separator = new Label(composite, 258);
        GridData gd2 = new GridData(512);
        gd2.horizontalAlignment = 4;
        gd2.horizontalSpan = 2;
        separator.setLayoutData((Object)gd2);
        String tooltip = "The Android Project where the new resource file will be created.";
        Label projectLabel = new Label(composite, 0);
        projectLabel.setText("Project:");
        projectLabel.setToolTipText(tooltip);
        ProjectChooserHelper helper = new ProjectChooserHelper(this.getShell(), null);
        this.mProjectButton = new ProjectChooserHelper.ProjectCombo(helper, composite, this.mValues.project);
        this.mProjectButton.setToolTipText(tooltip);
        this.mProjectButton.setLayoutData(new GridData(768));
        this.mProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IProject project = NewXmlFileCreationPage.this.mProjectButton.getSelectedProject();
                if (project != ((NewXmlFileCreationPage)NewXmlFileCreationPage.this).mValues.project) {
                    NewXmlFileCreationPage.this.changeProject(project);
                }
            }
        });
        Label fileLabel = new Label(composite, 0);
        fileLabel.setText("File:");
        fileLabel.setToolTipText("The name of the resource file to create.");
        this.mFileNameTextField = new Text(composite, 2048);
        this.mFileNameTextField.setLayoutData((Object)new GridData(768));
        this.mFileNameTextField.setToolTipText(tooltip);
        this.mFileNameTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ((NewXmlFileCreationPage)NewXmlFileCreationPage.this).mValues.name = NewXmlFileCreationPage.this.mFileNameTextField.getText();
                NewXmlFileCreationPage.this.validatePage();
            }
        });
        Label rootSeparator = new Label(composite, 258);
        GridData gd = new GridData(512);
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        rootSeparator.setLayoutData((Object)gd);
        Label rootLabel = new Label(composite, 0);
        rootLabel.setText("Root Element:");
        new Label(composite, 0);
        this.mRootTableViewer = new TableViewer(composite, 67584);
        this.mRootTable = this.mRootTableViewer.getTable();
        GridData tableGridData = new GridData(4, 4, true, true, 2, 1);
        tableGridData.heightHint = 200;
        this.mRootTable.setLayoutData((Object)tableGridData);
        this.setControl((Control)composite);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.initializeFromSelection(this.mInitialSelection);
        this.updateAvailableTypes();
        this.initializeFromFixedType();
        this.initializeRootValues();
        this.installTargetChangeListener();
        this.initialSelectType();
        this.validatePage();
    }

    private void initialSelectType() {
        TypeInfo[] types = (TypeInfo[])this.mTypeCombo.getData();
        int typeIndex = this.getTypeComboIndex(this.mValues.type);
        if (typeIndex == -1) {
            typeIndex = 0;
        } else assert (this.mValues.type == types[typeIndex]);
        this.mTypeCombo.select(typeIndex);
        this.onSelectType(types[typeIndex]);
        this.updateRootCombo(types[typeIndex]);
    }

    private void installTargetChangeListener() {
        this.mSdkTargetChangeListener = new Sdk.TargetChangeListener(){

            @Override
            public IProject getProject() {
                return ((NewXmlFileCreationPage)NewXmlFileCreationPage.this).mValues.project;
            }

            @Override
            public void reload() {
                if (((NewXmlFileCreationPage)NewXmlFileCreationPage.this).mValues.project != null) {
                    NewXmlFileCreationPage.this.changeProject(((NewXmlFileCreationPage)NewXmlFileCreationPage.this).mValues.project);
                }
            }
        };
        AdtPlugin.getDefault().addTargetListener(this.mSdkTargetChangeListener);
    }

    public void dispose() {
        if (this.mSdkTargetChangeListener != null) {
            AdtPlugin.getDefault().removeTargetListener(this.mSdkTargetChangeListener);
            this.mSdkTargetChangeListener = null;
        }
        super.dispose();
    }

    public String getRootElement() {
        int index = this.mRootTable.getSelectionIndex();
        if (index >= 0) {
            Object[] roots = (Object[])this.mRootTableViewer.getInput();
            return roots[index].toString();
        }
        return null;
    }

    private boolean initializeFromSelection(IStructuredSelection selection) {
        IJavaProject[] projects;
        IEditorInput input;
        IEditorPart activeEditor;
        IWorkbenchPage page;
        IWorkbenchWindow window;
        if (selection == null) {
            return false;
        }
        IProject targetProject = null;
        String targetWsFolderPath = null;
        String targetFileName = null;
        int targetScore = 0;
        for (Object element : selection.toList()) {
            if (element instanceof IAdaptable) {
                IResource res = (IResource)((IAdaptable)element).getAdapter(IResource.class);
                IProject project = res != null ? res.getProject() : null;
                try {
                    if (project == null) continue;
                    if (!project.hasNature("com.android.ide.eclipse.adt.AndroidNature")) {
                    }
                }
                catch (CoreException coreException) {}
                continue;
                int score = 1;
                IPath wsFolderPath = null;
                String fileName = null;
                assert (res != null);
                if (res.getType() == 2) {
                    wsFolderPath = res.getProjectRelativePath();
                } else if (res.getType() == 1) {
                    if (SdkUtils.endsWithIgnoreCase((String)res.getName(), (String)".xml")) {
                        fileName = res.getName();
                    }
                    wsFolderPath = res.getParent().getProjectRelativePath();
                }
                if (wsFolderPath != null && wsFolderPath.segmentCount() > 1 && "res".equals(wsFolderPath.segment(0))) {
                    score += 2;
                } else {
                    wsFolderPath = null;
                    fileName = null;
                }
                if ((score += fileName != null ? 4 : 0) <= targetScore) continue;
                targetScore = score;
                targetProject = project;
                targetWsFolderPath = wsFolderPath != null ? wsFolderPath.toString() : null;
                targetFileName = fileName;
                continue;
            }
            if (!(element instanceof Pair)) continue;
            Pair pair = (Pair)element;
            targetScore = 1;
            targetProject = (IProject)pair.getFirst();
            targetWsFolderPath = (String)pair.getSecond();
            targetFileName = "";
        }
        if (targetProject == null && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null && (activeEditor = page.getActiveEditor()) instanceof AndroidXmlEditor && (input = ((AndroidXmlEditor)activeEditor).getEditorInput()) instanceof FileEditorInput) {
            FileEditorInput fileInput = (FileEditorInput)input;
            targetScore = 1;
            IFile file = fileInput.getFile();
            targetProject = file.getProject();
            IPath path = file.getParent().getProjectRelativePath();
            String string = targetWsFolderPath = path != null ? path.toString() : null;
        }
        if (targetProject == null && (projects = AdtUtils.getOpenAndroidProjects()) != null && projects.length == 1) {
            targetScore = 1;
            targetProject = projects[0].getProject();
        }
        if (targetScore > 0) {
            this.mValues.project = targetProject;
            this.mValues.folderPath = targetWsFolderPath;
            this.mProjectButton.setSelectedProject(targetProject);
            this.mFileNameTextField.setText(targetFileName != null ? targetFileName : "");
            if (targetWsFolderPath != null) {
                String[] folderSegments;
                int pos = targetWsFolderPath.lastIndexOf(47);
                if (pos >= 0) {
                    targetWsFolderPath = targetWsFolderPath.substring(pos + 1);
                }
                if ((folderSegments = targetWsFolderPath.split("-")).length > 0) {
                    this.mValues.configuration = FolderConfiguration.getConfig((String[])folderSegments);
                    String folderName = folderSegments[0];
                    this.selectTypeFromFolder(folderName);
                }
            }
        }
        return true;
    }

    private void initializeFromFixedType() {
        if (this.mInitialFolderType != null) {
            TypeInfo[] typeInfoArray = sTypes;
            int n = sTypes.length;
            int n2 = 0;
            while (n2 < n) {
                TypeInfo type = typeInfoArray[n2];
                if (type.getResFolderType() == this.mInitialFolderType) {
                    this.mValues.type = type;
                    this.updateFolderPath(type);
                    break;
                }
                ++n2;
            }
        }
    }

    void selectTypeFromFolder(String folderName) {
        ArrayList<TypeInfo> matches = new ArrayList<TypeInfo>();
        boolean selected = false;
        TypeInfo selectedType = this.getSelectedType();
        TypeInfo[] typeInfoArray = sTypes;
        int n = sTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TypeInfo type = typeInfoArray[n2];
            if (type.getResFolderName().equals(folderName)) {
                matches.add(type);
                selected |= type == selectedType;
            }
            ++n2;
        }
        if (matches.size() == 1) {
            if (!selected) {
                this.selectType((TypeInfo)matches.get(0));
            }
        } else if (matches.size() > 1) {
            if (!selected) {
                this.selectType(null);
            }
        } else {
            this.selectType(null);
        }
    }

    private void initializeRootValues() {
        IProject project = this.mValues.project;
        TypeInfo[] typeInfoArray = sTypes;
        int n = sTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Object rootSeed;
            TypeInfo type = typeInfoArray[n2];
            ArrayList<String> roots = type.getRoots();
            if (roots.size() > 0) {
                roots.clear();
            }
            if ((rootSeed = type.getRootSeed()) instanceof String) {
                roots.add((String)rootSeed);
            } else if (rootSeed instanceof String[]) {
                String[] stringArray = (String[])rootSeed;
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String value = stringArray[n4];
                    roots.add(value);
                    ++n4;
                }
            } else if (rootSeed instanceof Integer && project != null) {
                IAndroidTarget target = null;
                AndroidTargetData data = null;
                target = Sdk.getCurrent().getTarget(project);
                if (target == null) {
                    AdtPlugin.log(1, "NewXmlFile wizard: no platform target for project %s", project.getName());
                } else {
                    data = Sdk.getCurrent().getTargetData(target);
                    if (data == null) {
                        AdtPlugin.log(1, "NewXmlFile wizard: no data for target %s, project %s", target.getName(), project.getName());
                    } else {
                        IDescriptorProvider provider = data.getDescriptorProvider((Integer)rootSeed);
                        ElementDescriptor descriptor = provider.getDescriptor();
                        if (descriptor != null) {
                            HashSet<ElementDescriptor> visited = new HashSet<ElementDescriptor>();
                            this.initRootElementDescriptor(roots, descriptor, visited);
                        }
                        Collections.sort(roots);
                    }
                }
            }
            ++n2;
        }
    }

    private void initRootElementDescriptor(ArrayList<String> roots, ElementDescriptor desc, HashSet<ElementDescriptor> visited) {
        String xmlName;
        if (!(desc instanceof DocumentDescriptor) && (xmlName = desc.getXmlName()) != null && xmlName.length() > 0) {
            roots.add(xmlName);
        }
        visited.add(desc);
        ElementDescriptor[] elementDescriptorArray = desc.getChildren();
        int n = elementDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ElementDescriptor child = elementDescriptorArray[n2];
            if (!visited.contains(child)) {
                this.initRootElementDescriptor(roots, child, visited);
            }
            ++n2;
        }
    }

    private void changeProject(IProject newProject) {
        this.mValues.project = newProject;
        this.updateAvailableTypes();
        this.initialSelectType();
        this.updateFolderPath(this.mValues.type);
        this.initializeRootValues();
        this.updateRootCombo(this.mValues.type);
        this.validatePage();
    }

    private void onSelectType(TypeInfo type) {
        if (this.mInternalTypeUpdate) {
            return;
        }
        this.mValues.type = type;
        if (type == null) {
            return;
        }
        this.updateRootCombo(type);
        this.updateFolderPath(type);
        this.validatePage();
    }

    private void setSelectedType(TypeInfo type) {
        TypeInfo[] types = (TypeInfo[])this.mTypeCombo.getData();
        if (types != null) {
            int i = 0;
            int n = types.length;
            while (i < n) {
                if (types[i] == type) {
                    this.mTypeCombo.select(i);
                    break;
                }
                ++i;
            }
        }
    }

    private TypeInfo getSelectedType() {
        int index = this.mTypeCombo.getSelectionIndex();
        if (index != -1) {
            TypeInfo[] types = (TypeInfo[])this.mTypeCombo.getData();
            return types[index];
        }
        return null;
    }

    private int getTypeComboIndex(TypeInfo type) {
        TypeInfo[] types = (TypeInfo[])this.mTypeCombo.getData();
        int i = 0;
        int n = types.length;
        while (i < n) {
            if (type == types[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void updateFolderPath(TypeInfo type) {
        String wsFolderPath = this.mValues.folderPath;
        String newPath = null;
        FolderConfiguration config = this.mValues.configuration;
        ResourceQualifier qual = config.getInvalidQualifier();
        if (qual == null) {
            newPath = "/res/" + config.getFolderName(type.getResFolderType());
        } else if (wsFolderPath.startsWith("/res/")) {
            wsFolderPath = wsFolderPath.replaceFirst("^(/res/)[^-]*(.*)", "\\1" + type.getResFolderName() + "\\2");
        } else {
            newPath = "/res/" + config.getFolderName(type.getResFolderType());
        }
        if (newPath != null && !newPath.equals(wsFolderPath)) {
            this.mValues.folderPath = newPath;
        }
    }

    private void updateRootCombo(TypeInfo type) {
        ColumnLabelProvider labelProvider = new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return IconFactory.getInstance().getIcon(element.toString());
            }
        };
        this.mRootTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.mRootTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        if (type != null) {
            ArrayList<String> roots = type.getRoots();
            this.mRootTableViewer.setInput((Object)roots.toArray());
            int index = 0;
            String defaultRoot = type.getDefaultRoot(this.mValues.project);
            if (defaultRoot != null) {
                index = roots.indexOf(defaultRoot);
            }
            this.mRootTable.select(index < 0 ? 0 : index);
            this.mRootTable.showSelection();
        }
    }

    private void selectType(TypeInfo type) {
        this.mInternalTypeUpdate = true;
        this.mValues.type = type;
        if (type == null) {
            if (this.mTypeCombo.getSelectionIndex() != -1) {
                this.mTypeCombo.deselect(this.mTypeCombo.getSelectionIndex());
            }
        } else {
            this.setSelectedType(type);
        }
        this.updateRootCombo(type);
        this.mInternalTypeUpdate = false;
    }

    private void updateAvailableTypes() {
        IProject project = this.mValues.project;
        IAndroidTarget target = project != null ? Sdk.getCurrent().getTarget(project) : null;
        int currentApiLevel = 1;
        if (target != null) {
            currentApiLevel = target.getVersion().getApiLevel();
        }
        ArrayList<String> items = new ArrayList<String>(sTypes.length);
        ArrayList<TypeInfo> types = new ArrayList<TypeInfo>(sTypes.length);
        int i = 0;
        int n = sTypes.length;
        while (i < n) {
            TypeInfo type = sTypes[i];
            if (type.getTargetApiLevel() <= currentApiLevel) {
                items.add(type.getUiName());
                types.add(type);
            }
            ++i;
        }
        this.mTypeCombo.setItems(items.toArray(new String[items.size()]));
        this.mTypeCombo.setData((Object)types.toArray(new TypeInfo[types.size()]));
    }

    private void validatePage() {
        IFile file;
        String error = null;
        String warning = null;
        TypeInfo type = this.mValues.type;
        if (type == null) {
            error = "One of the types must be selected (e.g. layout, values, etc.)";
        }
        if (this.mValues.project == null) {
            error = "Please select an Android project.";
        }
        if (error == null) {
            IAndroidTarget target = Sdk.getCurrent().getTarget(this.mValues.project);
            int currentApiLevel = 1;
            if (target != null) {
                currentApiLevel = target.getVersion().getApiLevel();
            }
            assert (type != null);
            if (type.getTargetApiLevel() > currentApiLevel) {
                error = "The API level of the selected type (e.g. AppWidget, etc.) is not compatible with the API level of the project.";
            }
        }
        if (error == null) {
            String fileName = this.mValues.getFileName();
            assert (type != null);
            ResourceFolderType folderType = type.getResFolderType();
            error = ResourceNameValidator.create(true, folderType).isValid(fileName);
        }
        if (error == null && (file = this.mValues.getDestinationFile()) != null && file.exists()) {
            warning = "The destination file already exists";
        }
        this.setPageComplete(error == null);
        if (error != null) {
            this.setMessage(error, 3);
        } else if (warning != null) {
            this.setMessage(warning, 2);
        } else {
            this.setErrorMessage(null);
            this.setMessage(null);
        }
    }

    static TypeInfo getTypeInfo(ResourceFolderType folderType) {
        TypeInfo[] typeInfoArray = sTypes;
        int n = sTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TypeInfo typeInfo = typeInfoArray[n2];
            if (typeInfo.getResFolderType() == folderType) {
                return typeInfo;
            }
            ++n2;
        }
        return null;
    }

    static class TypeInfo {
        private final String mUiName;
        private final ResourceFolderType mResFolderType;
        private final String mTooltip;
        private final Object mRootSeed;
        private ArrayList<String> mRoots = new ArrayList();
        private final String mXmlns;
        private final String mDefaultAttrs;
        private final String mDefaultRoot;
        private final int mTargetApiLevel;

        public TypeInfo(String uiName, String tooltip, ResourceFolderType resFolderType, Object rootSeed, String defaultRoot, String xmlns, String defaultAttrs, int targetApiLevel) {
            this.mUiName = uiName;
            this.mResFolderType = resFolderType;
            this.mTooltip = tooltip;
            this.mRootSeed = rootSeed;
            this.mDefaultRoot = defaultRoot;
            this.mXmlns = xmlns;
            this.mDefaultAttrs = defaultAttrs;
            this.mTargetApiLevel = targetApiLevel;
        }

        String getUiName() {
            return this.mUiName;
        }

        String getTooltip() {
            return this.mTooltip;
        }

        String getResFolderName() {
            return this.mResFolderType.getName();
        }

        ResourceFolderType getResFolderType() {
            return this.mResFolderType;
        }

        Object getRootSeed() {
            return this.mRootSeed;
        }

        String getDefaultRoot(IProject project) {
            return this.mDefaultRoot;
        }

        ArrayList<String> getRoots() {
            return this.mRoots;
        }

        String getXmlns() {
            return this.mXmlns;
        }

        String getDefaultAttrs(IProject project, String root) {
            return this.mDefaultAttrs;
        }

        String getChild(IProject project, String root) {
            return null;
        }

        public int getTargetApiLevel() {
            return this.mTargetApiLevel;
        }
    }
}

