/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.templates;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.assetstudiolib.GraphicGenerator;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.assetstudio.AssetType;
import com.android.ide.eclipse.adt.internal.assetstudio.CreateAssetSetWizardState;
import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.ImageUtils;
import com.android.ide.eclipse.adt.internal.wizards.templates.Parameter;
import com.android.ide.eclipse.adt.internal.wizards.templates.StringEvaluator;
import com.android.utils.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.ast.libs.org.parboiled.google.collect.Lists;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class TemplateMetadata {
    private final Document mDocument;
    private final List<Parameter> mParameters;
    private final Map<String, Parameter> mParameterMap;
    private List<Pair<String, Integer>> mDependencies;
    private Integer mMinApi;
    private Integer mMinBuildApi;
    private Integer mRevision;
    private boolean mNoIcons;
    private CreateAssetSetWizardState mIconState;

    TemplateMetadata(@NonNull Document document) {
        this.mDocument = document;
        NodeList parameters = this.mDocument.getElementsByTagName("parameter");
        this.mParameters = new ArrayList<Parameter>(parameters.getLength());
        this.mParameterMap = new HashMap<String, Parameter>(parameters.getLength());
        int index = 0;
        int max = parameters.getLength();
        while (index < max) {
            Element element = (Element)parameters.item(index);
            Parameter parameter = new Parameter(this, element);
            this.mParameters.add(parameter);
            if (parameter.id != null) {
                this.mParameterMap.put(parameter.id, parameter);
            }
            ++index;
        }
    }

    boolean isSupported() {
        String versionString = this.mDocument.getDocumentElement().getAttribute("format");
        if (versionString != null && !versionString.isEmpty()) {
            try {
                int version = Integer.parseInt(versionString);
                return version <= 3;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    String getTitle() {
        String name = this.mDocument.getDocumentElement().getAttribute("name");
        if (name != null && !name.isEmpty()) {
            return name;
        }
        return null;
    }

    @Nullable
    String getDescription() {
        String description = this.mDocument.getDocumentElement().getAttribute("description");
        if (description != null && !description.isEmpty()) {
            return description;
        }
        return null;
    }

    int getMinSdk() {
        if (this.mMinApi == null) {
            this.mMinApi = 1;
            String api = this.mDocument.getDocumentElement().getAttribute("minApi");
            if (api != null && !api.isEmpty()) {
                try {
                    this.mMinApi = Integer.parseInt(api);
                }
                catch (NumberFormatException nufe) {
                    AdtPlugin.log(nufe, null, new Object[0]);
                    this.mMinApi = 1;
                }
            }
        }
        return this.mMinApi;
    }

    int getMinBuildApi() {
        if (this.mMinBuildApi == null) {
            this.mMinBuildApi = 1;
            String api = this.mDocument.getDocumentElement().getAttribute("minBuildApi");
            if (api != null && !api.isEmpty()) {
                try {
                    this.mMinBuildApi = Integer.parseInt(api);
                }
                catch (NumberFormatException nufe) {
                    AdtPlugin.log(nufe, null, new Object[0]);
                    this.mMinBuildApi = 1;
                }
            }
        }
        return this.mMinBuildApi;
    }

    public int getRevision() {
        if (this.mRevision == null) {
            this.mRevision = 1;
            String revision = this.mDocument.getDocumentElement().getAttribute("revision");
            if (revision != null && !revision.isEmpty()) {
                try {
                    this.mRevision = Integer.parseInt(revision);
                }
                catch (NumberFormatException nufe) {
                    AdtPlugin.log(nufe, null, new Object[0]);
                    this.mRevision = 1;
                }
            }
        }
        return this.mRevision;
    }

    @Nullable
    public CreateAssetSetWizardState getIconState(IProject project) {
        if (this.mIconState == null && !this.mNoIcons) {
            String sourceTypeString;
            String paddingString;
            String trimString;
            String shapeString;
            RGB foreground;
            RGB background;
            NodeList icons = this.mDocument.getElementsByTagName("icons");
            if (icons.getLength() < 1) {
                this.mNoIcons = true;
                return null;
            }
            Element icon = (Element)icons.item(0);
            this.mIconState = new CreateAssetSetWizardState();
            this.mIconState.project = project;
            String typeString = TemplateMetadata.getAttributeOrNull(icon, "type");
            if (typeString != null) {
                typeString = typeString.toUpperCase(Locale.US);
                boolean found = false;
                AssetType[] assetTypeArray = AssetType.values();
                int n = assetTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AssetType type = assetTypeArray[n2];
                    if (typeString.equals(type.name())) {
                        this.mIconState.type = type;
                        found = true;
                        break;
                    }
                    ++n2;
                }
                if (!found) {
                    AdtPlugin.log(null, "Unknown asset type %1$s", typeString);
                }
            }
            this.mIconState.outputName = TemplateMetadata.getAttributeOrNull(icon, "name");
            if (this.mIconState.outputName != null) {
                Parameter outputParameter = new Parameter(this, Parameter.Type.STRING, "_iconname", this.mIconState.outputName);
                this.getParameters().add(outputParameter);
            }
            if ((background = TemplateMetadata.getRgb(icon, "background")) != null) {
                this.mIconState.background = background;
            }
            if ((foreground = TemplateMetadata.getRgb(icon, "foreground")) != null) {
                this.mIconState.foreground = foreground;
            }
            if ((shapeString = TemplateMetadata.getAttributeOrNull(icon, "shape")) != null) {
                shapeString = shapeString.toUpperCase(Locale.US);
                boolean found = false;
                GraphicGenerator.Shape[] shapeArray = GraphicGenerator.Shape.values();
                int n = shapeArray.length;
                int n3 = 0;
                while (n3 < n) {
                    GraphicGenerator.Shape shape = shapeArray[n3];
                    if (shapeString.equals(shape.name())) {
                        this.mIconState.shape = shape;
                        found = true;
                        break;
                    }
                    ++n3;
                }
                if (!found) {
                    AdtPlugin.log(null, "Unknown shape %1$s", shapeString);
                }
            }
            if ((trimString = TemplateMetadata.getAttributeOrNull(icon, "trim")) != null) {
                this.mIconState.trim = Boolean.valueOf(trimString);
            }
            if ((paddingString = TemplateMetadata.getAttributeOrNull(icon, "padding")) != null) {
                this.mIconState.padding = Integer.parseInt(paddingString);
            }
            if ((sourceTypeString = TemplateMetadata.getAttributeOrNull(icon, "source")) != null) {
                sourceTypeString = sourceTypeString.toUpperCase(Locale.US);
                boolean found = false;
                CreateAssetSetWizardState.SourceType[] sourceTypeArray = CreateAssetSetWizardState.SourceType.values();
                int n = sourceTypeArray.length;
                int n4 = 0;
                while (n4 < n) {
                    CreateAssetSetWizardState.SourceType type = sourceTypeArray[n4];
                    if (sourceTypeString.equals(type.name())) {
                        this.mIconState.sourceType = type;
                        found = true;
                        break;
                    }
                    ++n4;
                }
                if (!found) {
                    AdtPlugin.log(null, "Unknown source type %1$s", sourceTypeString);
                }
            }
            this.mIconState.clipartName = TemplateMetadata.getAttributeOrNull(icon, "clipartName");
            String textString = TemplateMetadata.getAttributeOrNull(icon, "text");
            if (textString != null) {
                this.mIconState.text = textString;
            }
        }
        return this.mIconState;
    }

    void updateIconName(List<Parameter> parameters, StringEvaluator evaluator) {
        if (this.mIconState != null) {
            NodeList icons = this.mDocument.getElementsByTagName("icons");
            if (icons.getLength() < 1) {
                return;
            }
            Element icon = (Element)icons.item(0);
            String name = TemplateMetadata.getAttributeOrNull(icon, "name");
            if (name != null) {
                this.mIconState.outputName = evaluator.evaluate(name, parameters);
            }
        }
    }

    private static RGB getRgb(@NonNull Element element, @NonNull String name) {
        String colorString = TemplateMetadata.getAttributeOrNull(element, name);
        if (colorString != null) {
            int rgb = ImageUtils.getColor(colorString.trim());
            return ImageUtils.intToRgb(rgb);
        }
        return null;
    }

    @Nullable
    private static String getAttributeOrNull(@NonNull Element element, @NonNull String name) {
        String value = element.getAttribute(name);
        if (value != null && value.isEmpty()) {
            return null;
        }
        return value;
    }

    @Nullable
    String getThumbnailPath() {
        NodeList thumbs = this.mDocument.getElementsByTagName("thumb");
        if (thumbs.getLength() == 0) {
            return null;
        }
        int bestMatchCount = 0;
        Node bestMatch = null;
        int i = 0;
        int n = thumbs.getLength();
        while (i < n) {
            Element thumb = (Element)thumbs.item(i);
            NamedNodeMap attributes = thumb.getAttributes();
            if (bestMatch == null && attributes.getLength() == 0) {
                bestMatch = thumb;
            } else if (attributes.getLength() > bestMatchCount) {
                boolean match = true;
                int j = 0;
                int max = attributes.getLength();
                while (j < max) {
                    Attr attribute = (Attr)attributes.item(j);
                    Parameter parameter = this.mParameterMap.get(attribute.getName());
                    if (parameter == null) {
                        AdtPlugin.log(null, "Unexpected parameter in template thumbnail: %1$s", attribute.getName());
                    } else {
                        String editedValue;
                        String thumbNailValue = attribute.getValue();
                        String string = editedValue = parameter.value != null ? parameter.value.toString() : "";
                        if (!thumbNailValue.equals(editedValue)) {
                            match = false;
                            break;
                        }
                    }
                    ++j;
                }
                if (match) {
                    bestMatch = thumb;
                    bestMatchCount = attributes.getLength();
                }
            }
            ++i;
        }
        if (bestMatch != null) {
            NodeList children = bestMatch.getChildNodes();
            int i2 = 0;
            int n2 = children.getLength();
            while (i2 < n2) {
                Node child = children.item(i2);
                if (child.getNodeType() == 3) {
                    return child.getNodeValue().trim();
                }
                ++i2;
            }
        }
        return null;
    }

    List<Pair<String, Integer>> getDependencies() {
        if (this.mDependencies == null) {
            NodeList elements = this.mDocument.getElementsByTagName("dependency");
            if (elements.getLength() == 0) {
                return Collections.emptyList();
            }
            ArrayList dependencies = Lists.newArrayList();
            int i = 0;
            int n = elements.getLength();
            while (i < n) {
                Element element = (Element)elements.item(i);
                String name = element.getAttribute("name");
                int revision = -1;
                String revisionString = element.getAttribute("revision");
                if (!revisionString.isEmpty()) {
                    revision = Integer.parseInt(revisionString);
                }
                dependencies.add(Pair.of((Object)name, (Object)revision));
                ++i;
            }
            this.mDependencies = dependencies;
        }
        return this.mDependencies;
    }

    @NonNull
    List<Parameter> getParameters() {
        return this.mParameters;
    }

    @Nullable
    public Parameter getParameter(@NonNull String id) {
        for (Parameter parameter : this.mParameters) {
            if (!id.equals(parameter.id)) continue;
            return parameter;
        }
        return null;
    }

    static Image getDefaultTemplateIcon() {
        return IconFactory.getInstance().getIcon("default_template");
    }
}

