/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.templates;

import com.android.annotations.NonNull;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.assetstudio.ConfigureAssetSetPage;
import com.android.ide.eclipse.adt.internal.assetstudio.CreateAssetSetWizardState;
import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.wizards.templates.InstallDependencyPage;
import com.android.ide.eclipse.adt.internal.wizards.templates.NewTemplateWizard;
import com.android.ide.eclipse.adt.internal.wizards.templates.NewTemplateWizardState;
import com.android.ide.eclipse.adt.internal.wizards.templates.TemplateMetadata;
import com.android.ide.eclipse.adt.internal.wizards.templates.TemplatePreviewPage;
import com.android.ide.eclipse.adt.internal.wizards.templates.UpdateToolsPage;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

abstract class TemplateWizard
extends Wizard
implements INewWizard {
    private static final String PROJECT_LOGO_LARGE = "android-64";
    protected IWorkbench mWorkbench;
    private UpdateToolsPage mUpdatePage;
    private InstallDependencyPage mDependencyPage;
    private TemplatePreviewPage mPreviewPage;
    protected ConfigureAssetSetPage mIconPage;

    protected TemplateWizard() {
    }

    protected boolean shouldAddIconPage() {
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.mWorkbench = workbench;
        this.setHelpAvailable(false);
        ImageDescriptor desc = IconFactory.getInstance().getImageDescriptor(PROJECT_LOGO_LARGE);
        this.setDefaultPageImageDescriptor(desc);
        if (!UpdateToolsPage.isUpToDate()) {
            this.mUpdatePage = new UpdateToolsPage();
        }
        this.setNeedsProgressMonitor(true);
        AdtPlugin.getDefault().refreshSdk();
    }

    public void addPages() {
        super.addPages();
        if (this.mUpdatePage != null) {
            this.addPage((IWizardPage)this.mUpdatePage);
        }
    }

    public IWizardPage getStartingPage() {
        if (this.mUpdatePage != null && this.mUpdatePage.isPageComplete()) {
            return this.getNextPage((IWizardPage)this.mUpdatePage);
        }
        return super.getStartingPage();
    }

    protected WizardPage getPreviewPage(NewTemplateWizardState values) {
        if (this.mPreviewPage == null) {
            this.mPreviewPage = new TemplatePreviewPage(values);
            this.addPage((IWizardPage)this.mPreviewPage);
        }
        return this.mPreviewPage;
    }

    protected WizardPage getIconPage(CreateAssetSetWizardState iconState) {
        if (this.mIconPage == null) {
            this.mIconPage = new ConfigureAssetSetPage(iconState);
            this.mIconPage.setTitle("Configure Icon");
            this.addPage((IWizardPage)this.mIconPage);
        }
        return this.mIconPage;
    }

    protected WizardPage getDependencyPage(TemplateMetadata template, boolean create) {
        if (!create) {
            return this.mDependencyPage;
        }
        if (this.mDependencyPage == null) {
            this.mDependencyPage = new InstallDependencyPage();
            this.addPage((IWizardPage)this.mDependencyPage);
        }
        this.mDependencyPage.setTemplate(template);
        return this.mDependencyPage;
    }

    @NonNull
    protected abstract IProject getProject();

    @NonNull
    protected abstract List<String> getFilesToOpen();

    protected abstract List<Change> computeChanges();

    protected boolean performFinish(IProgressMonitor monitor) throws InvocationTargetException {
        List<Change> changes = this.computeChanges();
        if (!changes.isEmpty()) {
            monitor.beginTask("Creating template...", changes.size());
            try {
                try {
                    CompositeChange composite = new CompositeChange("", changes.toArray(new Change[changes.size()]));
                    composite.perform(monitor);
                }
                catch (CoreException e) {
                    AdtPlugin.log(e, null, new Object[0]);
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                monitor.done();
            }
        }
        try {
            this.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            AdtPlugin.log(e, null, new Object[0]);
        }
        return true;
    }

    public boolean performFinish() {
        final AtomicBoolean success = new AtomicBoolean();
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    boolean ok = TemplateWizard.this.performFinish(monitor);
                    success.set(ok);
                }
            });
        }
        catch (InvocationTargetException e) {
            AdtPlugin.log(e, null, new Object[0]);
            return false;
        }
        catch (InterruptedException e) {
            AdtPlugin.log(e, null, new Object[0]);
            return false;
        }
        if (success.get()) {
            NewTemplateWizard.openFiles(this.getProject(), this.getFilesToOpen(), this.mWorkbench);
            return true;
        }
        return false;
    }
}

