/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.Arrays;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.oredict.OreDictionary;
import powercrystals.core.CoreLoader;
import powercrystals.core.oredict.OreDictTracker;
import powercrystals.core.updater.IUpdateableMod;
import powercrystals.core.updater.UpdateManager;

public class CoreCore
extends DummyModContainer
implements IUpdateableMod {
    public static final String version = "1.6.2R1.1.7";
    public static final String modId = "PowerCrystalsCore";
    public static final String modName = "PowerCrystals Core";
    public static Property doUpdateCheck;
    public static Property doLivingDeath;
    public static CoreCore instance;

    public CoreCore() {
        super(new ModMetadata());
        ModMetadata modMetadata = super.getMetadata();
        modMetadata.modId = modId;
        modMetadata.name = modName;
        modMetadata.version = version.substring(version.indexOf(82) + 1);
        modMetadata.authorList = Arrays.asList("PowerCrystals", "AtomicStryker", "skyboy026");
        modMetadata.url = "http://minecraft.curseforge.com/mc-mods/powercrystalscore/";
        modMetadata.description = "Core functionality for Power Crystals' mods.";
    }

    public boolean registerBus(EventBus eventBus, LoadController loadController) {
        eventBus.register((Object)this);
        return true;
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent fMLPreInitializationEvent) {
        this.loadConfig(new File(fMLPreInitializationEvent.getModConfigurationDirectory().getAbsolutePath() + "/powercrystals/core/client.cfg"));
        this.loadServerConfig(new File(fMLPreInitializationEvent.getModConfigurationDirectory().getAbsolutePath() + "/powercrystals/core/server.cfg"));
    }

    @Subscribe
    public void init(FMLInitializationEvent fMLInitializationEvent) {
        for (String string : OreDictionary.getOreNames()) {
            for (ItemStack itemStack : OreDictionary.getOres((String)string)) {
                OreDictTracker.registerOreDictEntry(itemStack, string);
            }
        }
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    @ForgeSubscribe
    public void registerOreEvent(OreDictionary.OreRegisterEvent oreRegisterEvent) {
        OreDictTracker.registerOreDictEntry(oreRegisterEvent.Ore, oreRegisterEvent.Name);
    }

    @ForgeSubscribe
    public void onLivingDeathEvent(LivingDeathEvent livingDeathEvent) {
        if (!doLivingDeath.getBoolean(true) || livingDeathEvent.entity.field_70170_p.field_72995_K || !(livingDeathEvent.entity instanceof EntityLiving) || !((EntityLiving)livingDeathEvent.entityLiving).func_94056_bM()) {
            return;
        }
        ((WorldServer)livingDeathEvent.entity.field_70170_p).func_73046_m().func_71203_ab().func_92062_k(livingDeathEvent.entityLiving.func_110142_aN().func_94546_b());
    }

    @Subscribe
    public void load(FMLInitializationEvent fMLInitializationEvent) {
        TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)new UpdateManager(this), (Side)Side.CLIENT);
    }

    private void loadConfig(File file) {
        Configuration configuration = new Configuration(file);
        configuration.load();
        doUpdateCheck = configuration.get("general", "EnableUpdateCheck", true);
        CoreCore.doUpdateCheck.comment = "Set to false to disable update checks for all Power Crystals' mods.";
        configuration.save();
    }

    private void loadServerConfig(File file) {
        Configuration configuration = new Configuration(file);
        configuration.load();
        doLivingDeath = configuration.get("general", "EnableGenericDeathMessage", true);
        CoreCore.doLivingDeath.comment = "Set to true to display death messages for any named entity.";
        configuration.save();
    }

    @Override
    public String getModId() {
        return modId;
    }

    @Override
    public String getModName() {
        return modName;
    }

    @Override
    public String getModVersion() {
        return version;
    }

    public File getSource() {
        return CoreLoader.pccLocation;
    }

    public Class<?> getCustomResourcePackClass() {
        try {
            return this.getSource().isDirectory() ? Class.forName("cpw.mods.fml.client.FMLFolderResourcePack", true, this.getClass().getClassLoader()) : Class.forName("cpw.mods.fml.client.FMLFileResourcePack", true, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

