/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.BlockMultiID;
import ic2.core.block.TileEntityBarrel;
import ic2.core.init.InternalName;
import ic2.core.item.block.ItemBlockRare;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;

public class BlockBarrel
extends BlockMultiID {
    private static final int textureIndexNormal = 0;
    private static final int textureIndexTap = 1;

    public BlockBarrel(Configuration config, InternalName internalName) {
        super(config, internalName, Material.field_76245_d, ItemBlockRare.class);
        this.func_71848_c(1.0f);
        this.func_71884_a(field_71967_e);
        this.func_71849_a(null);
        Ic2Items.blockBarrel = new ItemStack((Block)this);
    }

    @Override
    public String getTextureName(int index) {
        if (index == 0) {
            return this.func_71917_a();
        }
        if (index == 1) {
            return this.func_71917_a() + "." + InternalName.tap.name();
        }
        return null;
    }

    @Override
    public int getTextureIndex(int meta) {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess iBlockAccess, int x, int y, int z, int side) {
        TileEntity tileEntity = iBlockAccess.func_72796_p(x, y, z);
        int subIndex = this.getTextureSubIndex(side, 3);
        if (side > 1 && tileEntity instanceof TileEntityBarrel && ((TileEntityBarrel)tileEntity).treetapSide == side) {
            return this.textures[1][subIndex];
        }
        return this.textures[0][subIndex];
    }

    @Override
    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float a, float b, float c) {
        return ((TileEntityBarrel)world.func_72796_p(x, y, z)).rightclick(entityPlayer);
    }

    public void func_71921_a(World world, int x, int y, int z, EntityPlayer player) {
        TileEntityBarrel barrel = (TileEntityBarrel)world.func_72796_p(x, y, z);
        if (barrel.treetapSide > 1) {
            if (IC2.platform.isSimulating()) {
                StackUtil.dropAsEntity(world, x, y, z, new ItemStack(Ic2Items.treetap.func_77973_b()));
            }
            barrel.treetapSide = 0;
            barrel.update();
            barrel.drainLiquid(1);
            return;
        }
        if (IC2.platform.isSimulating()) {
            StackUtil.dropAsEntity(world, x, y, z, new ItemStack(Ic2Items.barrel.func_77973_b(), 1, barrel.calculateMetaValue()));
        }
        world.func_72832_d(x, y, z, Ic2Items.scaffold.field_77993_c, 0, 3);
    }

    @Override
    public TileEntity createTileEntity(World world, int metaData) {
        return new TileEntityBarrel();
    }

    @Override
    public ArrayList<ItemStack> getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> re = new ArrayList<ItemStack>();
        re.add(new ItemStack(Ic2Items.scaffold.func_77973_b()));
        re.add(new ItemStack(Ic2Items.barrel.func_77973_b(), 1, 0));
        return re;
    }
}

