/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.event.RetextureEvent;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.init.InternalName;
import ic2.core.item.ItemIC2;
import ic2.core.item.tool.RenderObscurator;
import ic2.core.network.IPlayerItemDataListener;
import ic2.core.util.StackUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet15Place;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class ItemObscurator
extends ItemIC2
implements IElectricItem,
IPlayerItemDataListener {
    private final int scanOperationCost = 20000;
    private final int printOperationCost = 5000;

    public ItemObscurator(Configuration config, InternalName internalName) {
        super(config, internalName);
        this.func_77656_e(27);
        this.func_77625_d(1);
        if (IC2.platform.isRendering()) {
            MinecraftForgeClient.registerItemRenderer((int)this.field_77779_bT, (IItemRenderer)new RenderObscurator());
        }
    }

    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        int blockId;
        Block block;
        if (!entityPlayer.func_70093_af() && ElectricItem.manager.canUse(itemStack, 5000)) {
            NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
            int referencedBlockId = nbtData.func_74762_e("referencedBlockId");
            if (referencedBlockId <= 0 || referencedBlockId >= Block.field_71973_m.length || Block.field_71973_m[referencedBlockId] == null || !this.isBlockSuitable(Block.field_71973_m[referencedBlockId])) {
                return false;
            }
            if (IC2.platform.isSimulating()) {
                RetextureEvent event = new RetextureEvent(world, x, y, z, side, nbtData.func_74762_e("referencedBlockId"), nbtData.func_74762_e("referencedMeta"), nbtData.func_74762_e("referencedSide"));
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (event.applied) {
                    ElectricItem.manager.use(itemStack, 5000, (EntityLivingBase)entityPlayer);
                    return true;
                }
                return false;
            }
            PacketDispatcher.sendPacketToServer((Packet)new Packet15Place(x, y, z, side, entityPlayer.field_71071_by.func_70448_g(), hitX, hitY, hitZ));
            return true;
        }
        if (entityPlayer.func_70093_af() && IC2.platform.isRendering() && ElectricItem.manager.canUse(itemStack, 20000) && (block = Block.field_71973_m[blockId = world.func_72798_a(x, y, z)]) != null && !block.isAirBlock(world, x, y, z) && this.isBlockSuitable(block)) {
            int meta = world.func_72805_g(x, y, z);
            try {
                Icon texture = block.func_71858_a(side, meta);
                Icon textureWorld = block.func_71895_b((IBlockAccess)world, x, y, z, side);
                if (texture == null || texture != textureWorld) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
            if (nbtData.func_74762_e("referencedBlockId") != blockId || nbtData.func_74762_e("referencedMeta") != meta || nbtData.func_74762_e("referencedSide") != side) {
                IC2.network.sendPlayerItemData(entityPlayer, entityPlayer.field_71071_by.field_70461_c, blockId, meta, side);
                return true;
            }
        }
        return false;
    }

    @Override
    public void onPlayerItemNetworkData(EntityPlayer entityPlayer, int slot, Object ... data) {
        ItemStack itemStack = entityPlayer.field_71071_by.field_70462_a[slot];
        if (ElectricItem.manager.use(itemStack, 20000, (EntityLivingBase)entityPlayer)) {
            NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
            nbtData.func_74768_a("referencedBlockId", ((Integer)data[0]).intValue());
            nbtData.func_74768_a("referencedMeta", ((Integer)data[1]).intValue());
            nbtData.func_74768_a("referencedSide", ((Integer)data[2]).intValue());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int i, CreativeTabs tabs, List itemList) {
        ItemStack charged = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(charged, Integer.MAX_VALUE, Integer.MAX_VALUE, true, false);
        itemList.add(charged);
        itemList.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    @Override
    public int getChargedItemId(ItemStack itemStack) {
        return this.field_77779_bT;
    }

    @Override
    public int getEmptyItemId(ItemStack itemStack) {
        return this.field_77779_bT;
    }

    @Override
    public int getMaxCharge(ItemStack itemStack) {
        return 100000;
    }

    @Override
    public int getTier(ItemStack itemStack) {
        return 2;
    }

    @Override
    public int getTransferLimit(ItemStack itemStack) {
        return 250;
    }

    private boolean isBlockSuitable(Block block) {
        return block.func_71886_c();
    }
}

