/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.position.IRotateableTile;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.rednet.IConnectableRedNet;
import powercrystals.minefactoryreloaded.api.rednet.RedNetConnectionType;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.gui.MFRCreativeTab;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.tile.conveyor.TileEntityConveyor;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityCollector;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityItemRouter;

public class BlockConveyor
extends BlockContainer
implements IConnectableRedNet {
    private String[] _names = new String[]{"white", "orange", "magenta", "lightblue", "yellow", "lime", "pink", "gray", "lightgray", "cyan", "purple", "blue", "brown", "green", "red", "black", "default"};
    private Icon[] _iconsActive = new Icon[this._names.length];
    private Icon[] _iconsStopped = new Icon[this._names.length];

    public BlockConveyor(int n) {
        super(n, Material.field_76265_p);
        this.func_71848_c(0.5f);
        this.func_71864_b("mfr.conveyor");
        this.func_71905_a(0.0f, 0.0f, 0.0f, 0.1f, 0.01f, 0.1f);
        this.func_71849_a(MFRCreativeTab.tab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        for (int i = 0; i < this._names.length; ++i) {
            this._iconsActive[i] = iconRegister.func_94245_a("minefactoryreloaded:" + this.func_71917_a() + ".active." + this._names[i]);
            this._iconsStopped[i] = iconRegister.func_94245_a("minefactoryreloaded:" + this.func_71917_a() + ".stopped." + this._names[i]);
        }
    }

    public Icon func_71895_b(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        TileEntity tileEntity = iBlockAccess.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityConveyor) {
            int n5 = ((TileEntityConveyor)tileEntity).getDyeColor();
            if (n5 == -1) {
                n5 = 16;
            }
            if (((TileEntityConveyor)tileEntity).getConveyorActive()) {
                return this._iconsActive[n5];
            }
            return this._iconsStopped[n5];
        }
        return this._iconsStopped[this._iconsStopped.length - 1];
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int n, int n2) {
        return this._iconsStopped[n2];
    }

    public void func_71860_a(World world, int n, int n2, int n3, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        TileEntity tileEntity;
        if (entityLivingBase == null) {
            return;
        }
        int n4 = MathHelper.func_76128_c((double)((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (n4 == 0) {
            world.func_72921_c(n, n2, n3, 1, 2);
        }
        if (n4 == 1) {
            world.func_72921_c(n, n2, n3, 2, 2);
        }
        if (n4 == 2) {
            world.func_72921_c(n, n2, n3, 3, 2);
        }
        if (n4 == 3) {
            world.func_72921_c(n, n2, n3, 0, 2);
        }
        if ((tileEntity = world.func_72796_p(n, n2, n3)) instanceof TileEntityConveyor) {
            ((TileEntityConveyor)tileEntity).setDyeColor(itemStack.func_77960_j() == 16 ? -1 : itemStack.func_77960_j());
        }
    }

    public void func_71869_a(World world, int n, int n2, int n3, Entity entity) {
        boolean bl;
        if (entity instanceof EntityPlayer && MFRConfig.conveyorNeverCapturesPlayers.getBoolean(false)) {
            return;
        }
        if (entity.getClass().getName().contains("thaumcraft.common.entities.golems") && MFRConfig.conveyorNeverCapturesTCGolems.getBoolean(false)) {
            return;
        }
        if (!(entity instanceof EntityItem || entity instanceof EntityXPOrb || entity instanceof EntityLivingBase && MFRConfig.conveyorCaptureNonItems.getBoolean(true))) {
            return;
        }
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (!(tileEntity instanceof TileEntityConveyor) || !((TileEntityConveyor)tileEntity).getConveyorActive()) {
            return;
        }
        if (!world.field_72995_K && entity instanceof EntityItem) {
            this.specialRoute(world, n, n2, n3, (EntityItem)entity);
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n4 = world.func_72805_g(n, n2, n3);
        int n5 = n4 & 3;
        boolean bl2 = (n4 & 4) != 0;
        boolean bl3 = bl = (n4 & 8) != 0;
        if (bl2) {
            d2 = 0.1405;
        } else if (entity.field_70163_u - (double)n2 < 0.1) {
            entity.field_70163_u = (double)n2 + 0.1;
        }
        if (bl2 || bl) {
            entity.field_70122_E = false;
        }
        if (n5 == 0) {
            d = 0.1;
        } else if (n5 == 1) {
            d3 = 0.1;
        } else if (n5 == 2) {
            d = -0.1;
        } else if (n5 == 3) {
            d3 = -0.1;
        }
        if (n5 == 0 || n5 == 2) {
            if (entity.field_70161_v > (double)n3 + 0.55) {
                d3 = -0.1;
            } else if (entity.field_70161_v < (double)n3 + 0.45) {
                d3 = 0.1;
            }
        } else if (n5 == 1 || n5 == 3) {
            if (entity.field_70165_t > (double)n + 0.55) {
                d = -0.1;
            } else if (entity.field_70165_t < (double)n + 0.45) {
                d = 0.1;
            }
        }
        this.setEntityVelocity(entity, d, d2, d3);
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).field_70143_R = 0.0f;
        } else if (entity instanceof EntityItem) {
            ((EntityItem)entity).field_70293_c = 40;
        }
    }

    public AxisAlignedBB func_71872_e(World world, int n, int n2, int n3) {
        int n4 = world.func_72805_g(n, n2, n3);
        if ((n4 & 0xC) == 0) {
            return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)n + 0.05f), (double)n2, (double)((float)n3 + 0.05f), (double)((float)(n + 1) - 0.05f), (double)((float)n2 + 0.01f), (double)((float)(n3 + 1) - 0.05f));
        }
        return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)n + 0.1f), (double)n2, (double)((float)n3 + 0.1f), (double)((float)(n + 1) - 0.1f), (double)((float)n2 + 0.01f), (double)((float)(n3 + 1) - 0.1f));
    }

    public AxisAlignedBB func_71911_a_(World world, int n, int n2, int n3) {
        int n4 = world.func_72805_g(n, n2, n3);
        if ((n4 & 0xC) == 0) {
            return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)n + 0.05f), (double)n2, (double)((float)n3 + 0.05f), (double)((float)(n + 1) - 0.05f), (double)((float)n2 + 0.1f), (double)((float)(n3 + 1) - 0.05f));
        }
        return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)n + 0.1f), (double)n2, (double)((float)n3 + 0.1f), (double)((float)(n + 1) - 0.1f), (double)((float)n2 + 0.1f), (double)((float)(n3 + 1) - 0.1f));
    }

    public boolean func_71926_d() {
        return false;
    }

    public MovingObjectPosition func_71878_a(World world, int n, int n2, int n3, Vec3 vec3, Vec3 vec32) {
        this.func_71902_a((IBlockAccess)world, n, n2, n3);
        return super.func_71878_a(world, n, n2, n3, vec3, vec32);
    }

    public void func_71902_a(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        int n4 = iBlockAccess.func_72805_g(n, n2, n3);
        if (n4 >= 4 && n4 <= 11) {
            this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        } else {
            this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        }
    }

    public boolean func_71886_c() {
        return false;
    }

    public int func_71857_b() {
        return MineFactoryReloadedCore.renderIdConveyor;
    }

    public int func_71925_a(Random random) {
        return 1;
    }

    public boolean func_71930_b(World world, int n, int n2, int n3) {
        return this.func_71854_d(world, n, n2, n3);
    }

    public boolean func_71854_d(World world, int n, int n2, int n3) {
        return world.isBlockSolidOnSide(n, n2 - 1, n3, ForgeDirection.UP);
    }

    public boolean rotateBlock(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        IRotateableTile iRotateableTile;
        if (world.field_72995_K) {
            return false;
        }
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof IRotateableTile && (iRotateableTile = (IRotateableTile)tileEntity).canRotate()) {
            iRotateableTile.rotate();
            return true;
        }
        return false;
    }

    public boolean func_71903_a(World world, int n, int n2, int n3, EntityPlayer entityPlayer, int n4, float f, float f2, float f3) {
        if (MFRUtil.isHoldingHammer(entityPlayer)) {
            TileEntity tileEntity = world.func_72796_p(n, n2, n3);
            if (tileEntity instanceof IRotateableTile) {
                ((IRotateableTile)tileEntity).rotate();
            }
            return true;
        }
        return false;
    }

    public void func_71863_a(World world, int n, int n2, int n3, int n4) {
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityConveyor) {
            ((TileEntityConveyor)tileEntity).updateConveyorActive();
        }
        if (!this.func_71854_d(world, n, n2, n3)) {
            world.func_94571_i(n, n2, n3);
        }
    }

    private void setEntityVelocity(Entity entity, double d, double d2, double d3) {
        entity.field_70159_w = d;
        entity.field_70181_x = d2;
        entity.field_70179_y = d3;
    }

    public TileEntity func_72274_a(World world) {
        return new TileEntityConveyor();
    }

    public ArrayList<ItemStack> getBlockDropped(World world, int n, int n2, int n3, int n4, int n5) {
        return new ArrayList<ItemStack>();
    }

    public void func_71852_a(World world, int n, int n2, int n3, int n4, int n5) {
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        int n6 = 16;
        if (tileEntity instanceof TileEntityConveyor && (n6 = ((TileEntityConveyor)tileEntity).getDyeColor()) == -1) {
            n6 = 16;
        }
        this.func_71929_a(world, n, n2, n3, new ItemStack(this.field_71990_ca, 1, n6));
        super.func_71852_a(world, n, n2, n3, n4, n5);
    }

    public boolean func_71853_i() {
        return false;
    }

    @Override
    public RedNetConnectionType getConnectionType(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return RedNetConnectionType.PlateSingle;
    }

    @Override
    public int[] getOutputValues(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return null;
    }

    @Override
    public int getOutputValue(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int n4) {
        return 0;
    }

    @Override
    public void onInputsChanged(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int[] nArray) {
    }

    @Override
    public void onInputChanged(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int n4) {
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityConveyor) {
            ((TileEntityConveyor)tileEntity).onRedNetChanged(n4);
        }
    }

    private void specialRoute(World world, int n, int n2, int n3, EntityItem entityItem) {
        TileEntity tileEntity = world.func_72796_p(n, n2 - 1, n3);
        if (tileEntity == null || entityItem.field_70128_L) {
            return;
        }
        if (tileEntity instanceof TileEntityItemRouter) {
            ItemStack itemStack = ((TileEntityItemRouter)tileEntity).routeItem(entityItem.func_92059_d());
            if (itemStack == null) {
                entityItem.func_70106_y();
                return;
            }
            entityItem.func_92058_a(itemStack);
        } else if (tileEntity instanceof TileEntityCollector) {
            ((TileEntityCollector)tileEntity).addToChests(entityItem);
        } else if (tileEntity instanceof TileEntityHopper && !((TileEntityHopper)tileEntity).func_98047_l()) {
            ItemStack itemStack = entityItem.func_92059_d().func_77946_l();
            itemStack.field_77994_a = 1;
            if ((itemStack = TileEntityHopper.func_94117_a((IInventory)((IInventory)tileEntity), (ItemStack)itemStack, (int)ForgeDirection.UP.ordinal())) == null) {
                --entityItem.func_92059_d().field_77994_a;
                ((TileEntityHopper)tileEntity).func_98046_c(8);
            }
        }
    }
}

