/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.core;

import java.util.List;
import powercrystals.core.position.Area;
import powercrystals.core.position.BlockPosition;
import powercrystals.minefactoryreloaded.core.TreeHarvestMode;

public class TreeHarvestManager {
    private List<BlockPosition> _treeBlocks;
    private int _currentBlock;
    private boolean _isLeafPass;
    private boolean _isDone;
    private TreeHarvestMode _harvestMode;
    private Area _treeArea;

    public TreeHarvestManager(Area area, TreeHarvestMode treeHarvestMode) {
        this._harvestMode = treeHarvestMode;
        this._treeArea = area;
        this.reset();
    }

    public BlockPosition getNextBlock() {
        return this._treeBlocks.get(this._currentBlock);
    }

    public void moveNext() {
        ++this._currentBlock;
        if (this._currentBlock >= this._treeBlocks.size()) {
            if (this._harvestMode == TreeHarvestMode.Fruit) {
                this._isDone = true;
            }
            if (this._isLeafPass) {
                this._currentBlock = 0;
                this._treeBlocks = this._harvestMode == TreeHarvestMode.HarvestInverted ? this._treeArea.getPositionsBottomFirst() : this._treeArea.getPositionsTopFirst();
                this._isLeafPass = false;
            } else {
                this._isDone = true;
            }
        }
    }

    public void reset() {
        this._currentBlock = 0;
        this._isLeafPass = true;
        this._treeBlocks = this._harvestMode == TreeHarvestMode.HarvestInverted ? this._treeArea.getPositionsTopFirst() : this._treeArea.getPositionsBottomFirst();
    }

    public boolean getIsLeafPass() {
        return this._isLeafPass;
    }

    public boolean getIsDone() {
        return this._isDone;
    }
}

