/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Icon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.item.ItemFactory;

public class ItemFactoryCup
extends ItemFactory
implements IFluidContainerItem {
    private int _maxUses = 0;
    private boolean _prefix = false;
    @SideOnly(value=Side.CLIENT)
    protected Icon fillIcon;
    protected static int MELTING_POINT = 523;

    public ItemFactoryCup(int n, int n2, int n3) {
        super(n);
        this.func_77625_d(n2);
        this._maxUses = n3;
        this.func_77656_e(n3);
        this.func_77627_a(true);
    }

    public void setDamage(ItemStack itemStack, int n) {
        super.setDamage(itemStack, n);
        new Throwable().printStackTrace();
    }

    public String func_77667_c(ItemStack itemStack) {
        if (this.getFluid(itemStack) != null) {
            return this.func_77658_a() + (this._prefix ? ".prefix" : ".suffix");
        }
        return this.func_77658_a();
    }

    public String getLocalizedName(String string) {
        String string2 = this.func_77658_a() + "." + string;
        if (StatCollector.func_94522_b((String)string2)) {
            return StatCollector.func_74838_a((String)string2);
        }
        return null;
    }

    public String func_77628_j(ItemStack itemStack) {
        int n = itemStack.func_77960_j();
        if (n != 0) {
            String string = this.getFluidName(itemStack);
            String string2 = this.getLocalizedName(string);
            if (string2 != null && !string2.isEmpty()) {
                return EnumChatFormatting.RESET + string2 + EnumChatFormatting.RESET;
            }
            if (string == null) {
                return super.func_77628_j(itemStack);
            }
            Fluid fluid = FluidRegistry.getFluid((String)string);
            if (fluid != null) {
                string = fluid.getLocalizedName();
            }
            this._prefix = true;
            string2 = super.func_77628_j(itemStack);
            this._prefix = false;
            string2 = string2 != null ? string2.trim() : "";
            string = (string2.isEmpty() ? "" : string2 + " ") + string;
            string2 = super.func_77628_j(itemStack);
            string2 = string2 != null ? string2.trim() : "";
            string = string + (string2.isEmpty() ? " Cup" : " " + string2);
            return string;
        }
        return super.func_77628_j(itemStack);
    }

    public ItemStack getContainerItemStack(ItemStack itemStack) {
        ItemFactoryCup itemFactoryCup = (ItemFactoryCup)itemStack.func_77973_b();
        int n = itemStack.func_77960_j() + 1;
        if (itemFactoryCup == null || n >= itemFactoryCup._maxUses) {
            return null;
        }
        itemStack = new ItemStack((Item)itemFactoryCup, 1, 0);
        itemStack.func_77964_b(n);
        return itemStack;
    }

    public String getFluidName(ItemStack itemStack) {
        NBTTagCompound nBTTagCompound = itemStack.field_77990_d;
        return nBTTagCompound == null || !nBTTagCompound.func_74764_b("fluid") ? null : nBTTagCompound.func_74775_l("fluid").func_74779_i("FluidName");
    }

    public FluidStack getFluid(ItemStack itemStack) {
        NBTTagCompound nBTTagCompound = itemStack.field_77990_d;
        FluidStack fluidStack = null;
        if (nBTTagCompound != null && nBTTagCompound.func_74764_b("fluid") && (fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nBTTagCompound.func_74775_l("fluid"))) == null) {
            nBTTagCompound.func_82580_o("fluid");
        }
        return fluidStack;
    }

    public int getCapacity(ItemStack itemStack) {
        return 1000;
    }

    public int fill(ItemStack itemStack, FluidStack fluidStack, boolean bl) {
        if (fluidStack == null || fluidStack.getFluid().isGaseous(fluidStack) || fluidStack.getFluid().getTemperature(fluidStack) > MELTING_POINT) {
            return 0;
        }
        int n = 0;
        int n2 = this.getCapacity(itemStack);
        NBTTagCompound nBTTagCompound = itemStack.field_77990_d;
        NBTTagCompound nBTTagCompound2 = null;
        FluidStack fluidStack2 = null;
        if (nBTTagCompound == null || !nBTTagCompound.func_74764_b("fluid") || (nBTTagCompound2 = nBTTagCompound.func_74775_l("fluid")) == null || (fluidStack2 = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nBTTagCompound2)) == null) {
            n = Math.min(n2, fluidStack.amount);
        }
        if (fluidStack2 == null) {
            if (bl) {
                fluidStack2 = fluidStack.copy();
            }
        } else {
            if (!fluidStack2.isFluidEqual(fluidStack)) {
                return 0;
            }
            n = Math.min(n2 - fluidStack2.amount, fluidStack.amount);
        }
        n = Math.max(n, 0);
        if (bl) {
            if (nBTTagCompound == null) {
                nBTTagCompound = itemStack.field_77990_d = new NBTTagCompound();
            }
            fluidStack2.amount = n;
            nBTTagCompound.func_74782_a("fluid", (NBTBase)fluidStack2.writeToNBT(nBTTagCompound2 == null ? new NBTTagCompound() : nBTTagCompound2));
            nBTTagCompound.func_74772_a("uniqifier", (long)(System.identityHashCode(fluidStack) << 32 | System.identityHashCode(itemStack)));
        }
        return n;
    }

    public FluidStack drain(ItemStack itemStack, int n, boolean bl) {
        NBTTagCompound nBTTagCompound = itemStack.field_77990_d;
        NBTTagCompound nBTTagCompound2 = null;
        FluidStack fluidStack = null;
        if (nBTTagCompound == null || !nBTTagCompound.func_74764_b("fluid") || (nBTTagCompound2 = nBTTagCompound.func_74775_l("fluid")) == null || (fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nBTTagCompound2)) == null) {
            return null;
        }
        int n2 = (int)((double)Math.min(n, fluidStack.amount) * (Math.max(Math.random() - 0.75, 0.0) + 0.75));
        if (bl) {
            if (nBTTagCompound.func_74764_b("toDrain")) {
                n2 = nBTTagCompound.func_74762_e("toDrain");
                nBTTagCompound.func_82580_o("toDrain");
            }
            nBTTagCompound.func_82580_o("fluid");
            nBTTagCompound.func_82580_o("uniqifier");
            itemStack.func_77964_b(itemStack.func_77960_j() + 1);
        } else {
            nBTTagCompound.func_74768_a("toDrain", n2);
        }
        fluidStack.amount = n2;
        return fluidStack;
    }

    public boolean hasDrinkableLiquid(ItemStack itemStack) {
        return MFRRegistry.getLiquidDrinkHandlers().containsKey(this.getFluidName(itemStack));
    }

    public ItemStack func_77654_b(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        ItemFactoryCup itemFactoryCup = (ItemFactoryCup)itemStack.func_77973_b();
        if (itemFactoryCup == null) {
            return null;
        }
        if (this.hasDrinkableLiquid(itemStack)) {
            MFRRegistry.getLiquidDrinkHandlers().get(this.getFluidName(itemStack)).onDrink(entityPlayer);
        }
        if (!entityPlayer.field_71075_bZ.field_75098_d) {
            ItemStack itemStack2 = itemFactoryCup.getContainerItemStack(itemStack);
            itemStack.func_77972_a(1, (EntityLivingBase)entityPlayer);
            if (itemStack2 != null) {
                return itemStack2;
            }
        }
        if (itemStack.field_77994_a <= 0) {
            itemStack.field_77994_a = 0;
        }
        return itemStack;
    }

    public int func_77626_a(ItemStack itemStack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack itemStack) {
        return this.hasDrinkableLiquid(itemStack) ? EnumAction.drink : EnumAction.none;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (this.hasDrinkableLiquid(itemStack)) {
            entityPlayer.func_71008_a(itemStack, this.func_77626_a(itemStack));
        }
        return itemStack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("minefactoryreloaded:" + this.func_77658_a());
        this.fillIcon = iconRegister.func_94245_a("minefactoryreloaded:" + this.func_77658_a() + ".fill");
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(ItemStack itemStack, int n) {
        switch (n) {
            case 1: {
                return this.fillIcon;
            }
        }
        return this.field_77791_bV;
    }
}

