/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.modhelpers.ic2;

import ic2.api.crops.CropCard;
import ic2.api.crops.ICropTile;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.api.IFactoryHarvestable;

public class HarvestableIC2Crop
implements IFactoryHarvestable {
    private int _blockId;
    private Method _getCropMethod;
    private Field _dirtyField;

    public HarvestableIC2Crop(int n) throws NoSuchMethodException, SecurityException, ClassNotFoundException, NoSuchFieldException {
        this._blockId = n;
        this._getCropMethod = Class.forName("ic2.core.block.TileEntityCrop").getMethod("crop", new Class[0]);
        this._dirtyField = Class.forName("ic2.core.block.TileEntityCrop").getField("dirty");
    }

    @Override
    public int getPlantId() {
        return this._blockId;
    }

    @Override
    public HarvestType getHarvestType() {
        return HarvestType.Normal;
    }

    @Override
    public boolean breakBlock() {
        return false;
    }

    @Override
    public boolean canBeHarvested(World world, Map<String, Boolean> map, int n, int n2, int n3) {
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity == null || !(tileEntity instanceof ICropTile)) {
            return false;
        }
        ICropTile iCropTile = (ICropTile)tileEntity;
        try {
            CropCard cropCard = (CropCard)this._getCropMethod.invoke((Object)iCropTile, new Object[0]);
            if (iCropTile.getID() < 0 || !cropCard.canBeHarvested(iCropTile) || cropCard.canGrow(iCropTile)) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    @Override
    public List<ItemStack> getDrops(World world, Random random, Map<String, Boolean> map, int n, int n2, int n3) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        ICropTile iCropTile = (ICropTile)world.func_72796_p(n, n2, n3);
        try {
            int n4;
            CropCard cropCard = (CropCard)this._getCropMethod.invoke((Object)iCropTile, new Object[0]);
            float f = cropCard.dropGainChance();
            for (n4 = 0; n4 < iCropTile.getGain(); ++n4) {
                f *= 1.03f;
            }
            f -= random.nextFloat();
            n4 = 0;
            while (f > 0.0f) {
                ++n4;
                f -= random.nextFloat();
            }
            ItemStack[] itemStackArray = new ItemStack[n4];
            for (int i = 0; i < n4; ++i) {
                itemStackArray[i] = cropCard.getGain(iCropTile);
                if (itemStackArray[i] == null || random.nextInt(100) > iCropTile.getGain()) continue;
                ++itemStackArray[i].field_77994_a;
            }
            iCropTile.setSize(cropCard.getSizeAfterHarvest(iCropTile));
            this._dirtyField.setBoolean(iCropTile, true);
            for (ItemStack itemStack : itemStackArray) {
                arrayList.add(itemStack);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    @Override
    public void preHarvest(World world, int n, int n2, int n3) {
    }

    @Override
    public void postHarvest(World world, int n, int n2, int n3) {
    }
}

