/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.modhelpers.pam;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableStandard;
import powercrystals.minefactoryreloaded.farmables.plantables.PlantableCropPlant;
import powercrystals.minefactoryreloaded.modhelpers.FertilizableCropReflection;
import powercrystals.minefactoryreloaded.modhelpers.pam.HarvestablePams;
import powercrystals.minefactoryreloaded.modhelpers.pam.HarvestablePamsPerennial;
import powercrystals.minefactoryreloaded.modhelpers.pam.PamFruit;
import powercrystals.minefactoryreloaded.modhelpers.pam.PamFruitCinnamon;
import powercrystals.minefactoryreloaded.modhelpers.pam.PlantablePamSpecial;

@Mod(modid="MineFactoryReloaded|CompatPams", name="MFR Compat: Pam's Mods", version="1.6.2R2.7.1", dependencies="after:MineFactoryReloaded;after:PamHCAsparagus;after:PamHCBean;after:PamHCBeet;after:PamHCBellpepper;after:PamHCBlackberry;after:PamHCBlueberry;after:PamHCBroccoli;after:PamHCCactusfruit;after:PamHCCandle;after:PamHCCantaloupe;after:PamHCCelery;after:PamHCChilipepper;after:PamHCCoffee;after:PamHCCorn;after:PamHCCotton;after:PamHCCranberry;after:PamHCCucumber;after:PamHCEggplant;after:PamHCGarlic;after:PamHCGinger;after:PamHCGrape;after:PamHCKiwi;after:PamHCLettuce;after:PamHCMustard;after:PamHCOnion;after:PamHCPeanut;after:PamHCPeas;after:PamHCPineapple;after:PamHCRadish;after:PamHCRaspberry;after:PamHCRice;after:PamHCRotten;after:PamHCSpiceleaf;after:PamHCStrawberry;after:PamHCSunflower;after:PamHCSweetpotato;after:PamHCTea;after:PamHCTomato;after:PamHCTurnip;after:PamHCWhitemushroom;after:PamHCZucchini;after:PamHarvestCraft;after:PamWeeeFlowers;after:PamHCApple;after:PamHCAvocado;after:PamHCBanana;after:PamHCCherry;after:PamHCCinnamon;after:PamHCCoconut;after:PamHCLemon;after:PamHCLime;after:PamHCMango;after:PamHCNutmeg;after:PamHCOlive;after:PamHCOrange;after:PamHCPapaya;after:PamHCPeach;after:PamHCPear;after:PamHCPeppercorn;after:PamHCPlum;after:PamHCPomegranate;after:PamHCStarfruit;after:PamHCVanillabean;after:PamHCWalnut")
@NetworkMod(clientSideRequired=false, serverSideRequired=false)
public class Pam {
    @Mod.EventHandler
    public static void load(FMLInitializationEvent fMLInitializationEvent) {
        Object object;
        if (!Loader.isModLoaded((String)"PamHarvestCraft")) {
            FMLLog.warning((String)"Pam's HC base missing - MFR Pam HC Compat not loading", (Object[])new Object[0]);
        } else {
            Pam.registerBush("Blackberry", true, true);
            Pam.registerBush("Blueberry", true, true);
            Pam.registerBush("Grape", true, true);
            Pam.registerBush("Kiwi", true, true);
            Pam.registerBush("Raspberry", true, true);
            Pam.registerBush("Spiceleaf", true, true);
            Pam.registerBush("Strawberry", true, true);
            Pam.registerBush("Sunflower", false, true);
            Pam.registerCrop("Asparagus", false, false);
            Pam.registerCrop("Bean", false, false);
            Pam.registerCrop("Beet", false, false);
            Pam.registerCrop("Bellpepper", true, false);
            Pam.registerCrop("Broccoli", false, false);
            Pam.registerCrop("Cantaloupe", true, false);
            Pam.registerCrop("Celery", false, false);
            Pam.registerCrop("Chilipepper", true, false);
            Pam.registerCrop("Coffee", true, false);
            Pam.registerCrop("Corn", true, false);
            Pam.registerCrop("Cucumber", true, false);
            Pam.registerCrop("Eggplant", true, false);
            Pam.registerCrop("Garlic", false, false);
            Pam.registerCrop("Ginger", false, false);
            Pam.registerCrop("Lettuce", false, false);
            Pam.registerCrop("Mustard", true, false);
            Pam.registerCrop("Onion", false, false);
            Pam.registerCrop("Peanut", false, false);
            Pam.registerCrop("Peas", true, false);
            Pam.registerCrop("Pineapple", false, false);
            Pam.registerCrop("Radish", false, false);
            Pam.registerCrop("Sweetpotato", false, false);
            Pam.registerCrop("Tea", false, false);
            Pam.registerCrop("Tomato", true, false);
            Pam.registerCrop("Turnip", false, false);
            Pam.registerCrop("Zucchini", true, false);
            Pam.registerPamMod("Candle", "Candleberry", Category.MISC, true, true, Block.field_72050_aA.field_71990_ca);
            Pam.registerMisc("Cotton", true, true);
            Pam.registerPamMod("Rice", "Rice", Category.CROP, false, false, Block.field_71943_B.field_71990_ca);
            Pam.registerPamMod("Cranberry", "Cranberry", Category.BUSH, false, true, Block.field_71943_B.field_71990_ca);
            Pam.registerPamMod("Whitemushroom", "Whitemushroom", Category.BUSH, false, true, Block.field_71951_J.field_71990_ca);
            Pam.registerPamMod("Rotten", "Rotten", Category.CROP, false, false, Block.field_72013_bc.field_71990_ca);
            Pam.registerPamMod("Cactusfruit", "Cactusfruit", Category.BUSH, true, true, Block.field_71939_E.field_71990_ca);
            Pam.registerFruit("Apple");
            Pam.registerFruit("Avocado");
            Pam.registerFruit("Banana");
            Pam.registerFruit("Cherry");
            Pam.registerFruit("Coconut");
            Pam.registerFruit("Lemon");
            Pam.registerFruit("Lime");
            Pam.registerFruit("Mango");
            Pam.registerFruit("Nutmeg");
            Pam.registerFruit("Olive");
            Pam.registerFruit("Orange");
            Pam.registerFruit("Papaya");
            Pam.registerFruit("Peach");
            Pam.registerFruit("Pear");
            Pam.registerFruit("Peppercorn");
            Pam.registerFruit("Plum");
            Pam.registerFruit("Pomegranate");
            Pam.registerFruit("Starfruit");
            Pam.registerFruit("Vanillabean");
            Pam.registerFruit("Walnut");
            Pam.registerCandle();
            Pam.registerCinnamon();
            try {
                object = Class.forName("mods.PamHarvestCraft.PamHarvestCraft");
                MFRRegistry.registerSludgeDrop(25, new ItemStack((Item)((Class)object).getField("saltItem").get(null)));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!Loader.isModLoaded((String)"PamWeeeFlowers")) {
            FMLLog.warning((String)"Pam's Weee! Flowers missing - MFR Pam Weee! Flowers Compat not loading", (Object[])new Object[0]);
        } else {
            object = new String[]{"White", "Orange", "Magenta", "LightBlue", "Yellow", "Lime", "Pink", "LightGrey", "DarkGrey", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"};
            try {
                Class<?> clazz = Class.forName("mods.PamWeeeFlowers.PamWeeeFlowers");
                MFRRegistry.registerHarvestable(new HarvestableStandard(((Block)clazz.getField((String)"pamFlower").get(null)).field_71990_ca, HarvestType.Normal));
                for (String string : object) {
                    int n = ((Item)clazz.getField((String)new StringBuilder().append((String)string.toLowerCase()).append((String)"flowerseedItem").toString()).get(null)).field_77779_bT;
                    int n2 = ((Block)clazz.getField((String)new StringBuilder().append((String)"pam").append((String)string.toLowerCase()).append((String)"flowerCrop").toString()).get(null)).field_71990_ca;
                    Method method = Class.forName("mods.PamWeeeFlowers.BlockPamFlowerCrop").getMethod("fertilize", World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                    MFRRegistry.registerPlantable(new PlantableCropPlant(n, n2));
                    MFRRegistry.registerHarvestable(new HarvestablePams(n2));
                    MFRRegistry.registerFertilizable(new FertilizableCropReflection(n2, method, 7));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                FMLLog.warning((String)"Unable to load Pam support for Weee! Flowers even though Weee! FLowers was present", (Object[])new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void registerBush(String string, boolean bl, boolean bl2) {
        Pam.registerPamModBasic(string, Category.BUSH, bl, bl2);
    }

    private static void registerCrop(String string, boolean bl, boolean bl2) {
        Pam.registerPamModBasic(string, bl ? Category.CROP_PERENNIAL : Category.CROP, bl, bl2);
    }

    private static void registerMisc(String string, boolean bl, boolean bl2) {
        Pam.registerPamModBasic(string, Category.MISC, bl, bl2);
    }

    private static void registerPamModBasic(String string, Category category, boolean bl, boolean bl2) {
        Pam.registerPamMod(string, string, category, bl, bl2, Block.field_72050_aA.field_71990_ca);
    }

    private static void registerPamMod(String string, String string2, Category category, boolean bl, boolean bl2, int n) {
        try {
            String string3 = string2.toLowerCase();
            String string4 = String.format("mods.PamHarvestCraft.%s.%s", category.getPackageName(), string.toLowerCase());
            Class<?> clazz = Class.forName(String.format("%s.PamHC%s", string4, string));
            int n2 = ((Block)clazz.getField((String)String.format((String)"pam%sCrop", (Object[])new Object[]{string3})).get(null)).field_71990_ca;
            int n3 = ((Item)clazz.getField((String)String.format((String)"%sseedItem", (Object[])new Object[]{string3})).get(null)).field_77779_bT;
            if (n == Block.field_72050_aA.field_71990_ca) {
                MFRRegistry.registerPlantable(new PlantableCropPlant(n3, n2));
            } else {
                MFRRegistry.registerPlantable(new PlantablePamSpecial(n2, n3, n));
            }
            if (bl2) {
                int n4 = ((Block)clazz.getField((String)String.format((String)"pam%sWild", (Object[])new Object[]{string3})).get(null)).field_71990_ca;
                MFRRegistry.registerHarvestable(new HarvestableStandard(n4, HarvestType.Normal));
            }
            if (bl) {
                MFRRegistry.registerHarvestable(new HarvestablePamsPerennial(n2));
            } else {
                MFRRegistry.registerHarvestable(new HarvestablePams(n2));
            }
            MFRRegistry.registerFertilizable(new FertilizableCropReflection(n2, Class.forName(String.format(bl ? "mods.PamHarvestCraft.BlockPamRegrowCrop" : "mods.PamHarvestCraft.BlockPamCrop", new Object[0])).getMethod("fertilize", World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE), 7));
        }
        catch (ClassNotFoundException classNotFoundException) {
            FMLLog.warning((String)"Unable to load Pam support for %s", (Object[])new Object[]{string});
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void registerFruit(String string) {
        try {
            Block block = (Block)Class.forName("mods.PamHarvestCraft.trees." + string.toLowerCase() + ".PamHC" + string).getField("pam" + string).get(null);
            MFRRegistry.registerFruit(new PamFruit(block.field_71990_ca));
        }
        catch (ClassNotFoundException classNotFoundException) {
            FMLLog.warning((String)"Unable to load Pam support for %s trees", (Object[])new Object[]{string});
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void registerCandle() {
        try {
            Block block = (Block)Class.forName("mods.PamHarvestCraft.misc.candle.PamHCCandle").getField("pamCandle").get(null);
            MFRRegistry.registerFruit(new PamFruit(block.field_71990_ca));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void registerCinnamon() {
        try {
            Block block = (Block)Class.forName("mods.PamHarvestCraft.trees.cinnamon.PamHCCinnamon").getField("pamCinnamon").get(null);
            Item item = (Item)Class.forName("mods.PamHarvestCraft.trees.cinnamon.PamHCCinnamon").getField("cinnamonItem").get(null);
            MFRRegistry.registerFruit(new PamFruitCinnamon(block.field_71990_ca, item.field_77779_bT));
            MFRRegistry.registerFruitLogBlockId(block.field_71990_ca);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static enum Category {
        BUSH("bushes"),
        CROP("crops.normal"),
        CROP_PERENNIAL("crops.regrow"),
        MISC("misc");

        private String packageName;

        private Category(String string2) {
            this.packageName = string2;
        }

        public String getPackageName() {
            return this.packageName;
        }
    }
}

