/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.base;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import powercrystals.core.util.Util;
import powercrystals.core.util.UtilInventory;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;
import universalelectricity.core.block.IElectrical;
import universalelectricity.core.electricity.ElectricityPack;

public abstract class TileEntityFactoryPowered
extends TileEntityFactoryInventory
implements IPowerReceptor,
IEnergySink,
IElectrical {
    public static final int energyPerEU = 4;
    public static final int energyPerMJ = 10;
    public static final int wPerEnergy = 7;
    private int _energyStored;
    protected int _energyActivation;
    protected int _energyRequiredThisTick = 0;
    private int _workDone;
    private int _idleTicks;
    protected List<ItemStack> failedDrops = null;
    private List<ItemStack> missedDrops = new ArrayList<ItemStack>();
    protected int _failedDropTicksMax = 20;
    private int _failedDropTicks = 0;
    protected PowerHandler _powerProvider;
    private boolean _isAddedToIC2EnergyNet;
    private boolean _addToNetOnNextTick;
    private int _ueBuffer;

    protected TileEntityFactoryPowered(Machine machine) {
        this(machine, machine.getActivationEnergyMJ());
    }

    protected TileEntityFactoryPowered(Machine machine, int n) {
        super(machine);
        this._energyActivation = n * 10;
        this._powerProvider = new PowerHandler(this, PowerHandler.Type.MACHINE);
        this.configurePowerProvider();
        this.setIsActive(false);
    }

    protected void configurePowerProvider() {
        int n = this.getMaxEnergyPerTick() / 10;
        int n2 = Math.min(n * 20, 1000);
        this._powerProvider.configure(n < 10 ? 1.0f : 10.0f, n2, 1.0f, 1000.0f);
        this._powerProvider.setPerdition(MFRPerdition.DEFAULT);
    }

    @Override
    public void func_70316_g() {
        int n;
        PowerHandler powerHandler;
        int n2;
        super.func_70316_g();
        this._energyStored = Math.min(this._energyStored, this.getEnergyStoredMax());
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        if (this._addToNetOnNextTick) {
            if (!this.field_70331_k.field_72995_K) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            }
            this._addToNetOnNextTick = false;
            this._isAddedToIC2EnergyNet = true;
        }
        if ((n2 = Math.min(this.getEnergyStoredMax() - this.getEnergyStored(), this.getMaxEnergyPerTick())) > 0 && (powerHandler = this._powerProvider) != null && (n = n2 / 10) > 0) {
            powerHandler.update();
            if (powerHandler.useEnergy(0.0f, n, false) > 0.0f) {
                int n3 = (int)(powerHandler.useEnergy(0.0f, n, true) * 10.0f);
                this._energyStored += n3;
                n2 -= n3;
            }
        }
        this._energyRequiredThisTick = n2;
        this.setIsActive(this._energyStored >= this._energyActivation * 2);
        if (this.failedDrops != null) {
            if (this._failedDropTicks < this._failedDropTicksMax) {
                ++this._failedDropTicks;
                return;
            }
            this._failedDropTicks = 0;
            if (!this.doDrop(this.failedDrops)) {
                this.setIdleTicks(this.getIdleTicksMax());
                return;
            }
            this.failedDrops = null;
        }
        if (Util.isRedstonePowered((TileEntity)this)) {
            this.setIdleTicks(this.getIdleTicksMax());
        } else if (this._idleTicks > 0) {
            --this._idleTicks;
        } else if (this._energyStored >= this._energyActivation && this.activateMachine()) {
            this._energyStored -= this._energyActivation;
        }
    }

    public boolean doDrop(ItemStack itemStack) {
        if ((itemStack = UtilInventory.dropStack((TileEntity)this, (ItemStack)itemStack, (ForgeDirection)this.getDropDirection())) != null && itemStack.field_77994_a > 0) {
            if (this.failedDrops == null) {
                this.failedDrops = new ArrayList<ItemStack>();
            }
            this.failedDrops.add(itemStack);
        }
        return true;
    }

    public boolean doDrop(List<ItemStack> list) {
        if (list == null || list.size() <= 0) {
            return true;
        }
        List<ItemStack> list2 = this.missedDrops;
        list2.clear();
        int n = list.size();
        while (n-- > 0) {
            ItemStack itemStack = list.get(n);
            if ((itemStack = UtilInventory.dropStack((TileEntity)this, (ItemStack)itemStack, (ForgeDirection)this.getDropDirection())) == null || itemStack.field_77994_a <= 0) continue;
            list2.add(itemStack);
        }
        if (list2.size() != 0) {
            if (list != this.failedDrops) {
                if (this.failedDrops == null) {
                    this.failedDrops = new ArrayList<ItemStack>();
                }
                this.failedDrops.addAll(list2);
            } else {
                this.failedDrops.clear();
                this.failedDrops.addAll(list2);
            }
            return false;
        }
        return true;
    }

    @Override
    public void func_70312_q() {
        super.func_70312_q();
        if (!this._isAddedToIC2EnergyNet) {
            this._addToNetOnNextTick = true;
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this._isAddedToIC2EnergyNet) {
            if (!this.field_70331_k.field_72995_K) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            }
            this._isAddedToIC2EnergyNet = false;
        }
    }

    protected abstract boolean activateMachine();

    @Override
    public void onBlockBroken() {
        super.onBlockBroken();
        if (this._isAddedToIC2EnergyNet) {
            this._isAddedToIC2EnergyNet = false;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        if (this.failedDrops != null) {
            while (this.failedDrops.size() > 0) {
                ItemStack itemStack = this.failedDrops.remove(0);
                if (itemStack == null) continue;
                float f = this.field_70331_k.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f2 = this.field_70331_k.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f3 = this.field_70331_k.field_73012_v.nextFloat() * 0.8f + 0.1f;
                while (itemStack.field_77994_a > 0) {
                    int n = this.field_70331_k.field_73012_v.nextInt(21) + 10;
                    if (n > itemStack.field_77994_a) {
                        n = itemStack.field_77994_a;
                    }
                    itemStack.field_77994_a -= n;
                    EntityItem entityItem = new EntityItem(this.field_70331_k, (double)((float)this.field_70329_l + f), (double)((float)this.field_70330_m + f2), (double)((float)this.field_70327_n + f3), new ItemStack(itemStack.field_77993_c, n, itemStack.func_77960_j()));
                    if (itemStack.func_77978_p() != null) {
                        entityItem.func_92059_d().func_77982_d(itemStack.func_77978_p());
                    }
                    float f4 = 0.05f;
                    entityItem.field_70159_w = (float)this.field_70331_k.field_73012_v.nextGaussian() * f4;
                    entityItem.field_70181_x = (float)this.field_70331_k.field_73012_v.nextGaussian() * f4 + 0.2f;
                    entityItem.field_70179_y = (float)this.field_70331_k.field_73012_v.nextGaussian() * f4;
                    this.field_70331_k.func_72838_d((Entity)entityItem);
                }
            }
        }
    }

    public int getMaxEnergyPerTick() {
        return this._energyActivation;
    }

    public int getEnergyStored() {
        return this._energyStored;
    }

    public abstract int getEnergyStoredMax();

    public void setEnergyStored(int n) {
        this._energyStored = n;
    }

    public int getWorkDone() {
        return this._workDone;
    }

    public abstract int getWorkMax();

    public void setWorkDone(int n) {
        this._workDone = n;
    }

    public int getIdleTicks() {
        return this._idleTicks;
    }

    public abstract int getIdleTicksMax();

    public void setIdleTicks(int n) {
        this._idleTicks = n;
    }

    @Override
    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        super.func_70310_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("energyStored", this._energyStored);
        nBTTagCompound.func_74768_a("workDone", this._workDone);
        nBTTagCompound.func_74768_a("ueBuffer", this._ueBuffer);
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        this._powerProvider.writeToNBT(nBTTagCompound2);
        nBTTagCompound.func_74766_a("powerProvider", nBTTagCompound2);
        if (this.failedDrops != null) {
            NBTTagList nBTTagList = new NBTTagList();
            for (ItemStack itemStack : this.failedDrops) {
                NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
                itemStack.func_77955_b(nBTTagCompound3);
                nBTTagList.func_74742_a((NBTBase)nBTTagCompound3);
            }
            nBTTagCompound.func_74782_a("DropItems", (NBTBase)nBTTagList);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        super.func_70307_a(nBTTagCompound);
        this._energyStored = Math.min(nBTTagCompound.func_74762_e("energyStored"), this.getEnergyStoredMax());
        this._workDone = Math.min(nBTTagCompound.func_74762_e("workDone"), this.getWorkMax());
        this._ueBuffer = nBTTagCompound.func_74762_e("ueBuffer");
        if (nBTTagCompound.func_74764_b("powerProvider")) {
            this._powerProvider.readFromNBT(nBTTagCompound.func_74775_l("powerProvider"));
        } else {
            this._powerProvider.readFromNBT(nBTTagCompound);
            nBTTagCompound.func_82580_o("latency");
            nBTTagCompound.func_82580_o("minEnergyReceived");
            nBTTagCompound.func_82580_o("maxEnergyReceived");
            nBTTagCompound.func_82580_o("maxStoreEnergy");
            nBTTagCompound.func_82580_o("minActivationEnergy");
            nBTTagCompound.func_82580_o("storedEnergy");
        }
        this.configurePowerProvider();
        if (nBTTagCompound.func_74764_b("DropItems")) {
            ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
            NBTTagList nBTTagList = nBTTagCompound.func_74761_m("DropItems");
            int n = nBTTagList.func_74745_c();
            while (n-- > 0) {
                NBTTagCompound nBTTagCompound2 = (NBTTagCompound)nBTTagList.func_74743_b(n);
                ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound2);
                if (itemStack == null || itemStack.field_77994_a <= 0) continue;
                arrayList.add(itemStack);
            }
            if (arrayList.size() != 0) {
                this.failedDrops = arrayList;
            }
        }
    }

    public int getEnergyRequired() {
        return Math.min(this.getEnergyStoredMax() - this.getEnergyStored(), this._energyRequiredThisTick);
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection forgeDirection) {
        return this._powerProvider.getPowerReceiver();
    }

    @Override
    public final void doWork(PowerHandler powerHandler) {
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType pipeType, ForgeDirection forgeDirection) {
        if (pipeType == IPipeTile.PipeType.POWER && this.machine.getActivationEnergyMJ() > 0) {
            return IPipeConnection.ConnectOverride.CONNECT;
        }
        return super.overridePipeConnection(pipeType, forgeDirection);
    }

    @Override
    public double demandedEnergyUnits() {
        return Math.max(this.getEnergyRequired() / 4, 0);
    }

    @Override
    public double injectEnergyUnits(ForgeDirection forgeDirection, double d) {
        double d2 = Math.max(Math.min(this.demandedEnergyUnits(), d), 0.0);
        int n = (int)(d2 * 4.0);
        this._energyStored += n;
        this._energyRequiredThisTick -= n;
        return d - d2;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity tileEntity, ForgeDirection forgeDirection) {
        return true;
    }

    @Override
    public int getMaxSafeInput() {
        return 128;
    }

    public int demandsEnergy() {
        return Math.max(this.getEnergyRequired() / 4, 0);
    }

    public int injectEnergy(Direction direction, int n) {
        int n2 = Math.max(Math.min(this.demandsEnergy(), n), 0);
        int n3 = n2 * 4;
        this._energyStored += n3;
        this._energyRequiredThisTick -= n3;
        return n - n2;
    }

    public boolean acceptsEnergyFrom(TileEntity tileEntity, Direction direction) {
        return true;
    }

    @Override
    public float getVoltage() {
        return 120.0f;
    }

    @Override
    public boolean canConnect(ForgeDirection forgeDirection) {
        return true;
    }

    @Override
    public float receiveElectricity(ForgeDirection forgeDirection, ElectricityPack electricityPack, boolean bl) {
        int n = this.getEnergyRequired();
        int n2 = this._ueBuffer;
        n2 = (int)((float)n2 + electricityPack.getWatts());
        int n3 = Math.min(n2 / 7, n);
        n -= n3;
        n2 -= n3 * 7;
        if (bl) {
            this._energyStored += n3;
            this._ueBuffer = n2;
            this._energyRequiredThisTick -= n3;
        }
        return n3 * 7;
    }

    @Override
    public float getRequest(ForgeDirection forgeDirection) {
        return Math.max(this.getEnergyRequired() * 7, 0);
    }

    @Override
    public ElectricityPack provideElectricity(ForgeDirection forgeDirection, ElectricityPack electricityPack, boolean bl) {
        return null;
    }

    @Override
    public float getProvide(ForgeDirection forgeDirection) {
        return 0.0f;
    }

    public static class MFRPerdition
    extends PowerHandler.PerditionCalculator {
        public static final MFRPerdition DEFAULT = new MFRPerdition();

        @Override
        public float applyPerdition(PowerHandler powerHandler, float f, long l) {
            return f;
        }
    }
}

