/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.IFactoryGrindable;
import powercrystals.minefactoryreloaded.api.MobDrop;
import powercrystals.minefactoryreloaded.core.GrindingDamage;
import powercrystals.minefactoryreloaded.core.HarvestAreaManager;
import powercrystals.minefactoryreloaded.core.IHarvestAreaContainer;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryPowered;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryPowered;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;
import powercrystals.minefactoryreloaded.world.GrindingWorld;
import powercrystals.minefactoryreloaded.world.GrindingWorldServer;
import powercrystals.minefactoryreloaded.world.IGrindingWorld;

public class TileEntityGrinder
extends TileEntityFactoryPowered
implements ITankContainerBucketable,
IHarvestAreaContainer {
    public static final int DAMAGE = 500000;
    private static Field recentlyHit;
    protected HarvestAreaManager _areaManager = new HarvestAreaManager(this, 2, 2, 1);
    protected Random _rand;
    protected IGrindingWorld _grindingWorld;
    protected GrindingDamage _damageSource;

    protected TileEntityGrinder(Machine machine) {
        super(machine);
        this._tank = new FluidTank(4000);
        this._rand = new Random();
    }

    public TileEntityGrinder() {
        this(Machine.Grinder);
        this._damageSource = new GrindingDamage();
    }

    @Override
    public String getGuiBackground() {
        return "grinder.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiFactoryPowered(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerFactoryPowered getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerFactoryPowered(this, inventoryPlayer);
    }

    public void func_70308_a(World world) {
        super.func_70308_a(world);
        if (this._grindingWorld != null) {
            this._grindingWorld.clearReferences();
        }
        this._grindingWorld = this.field_70331_k instanceof WorldServer ? new GrindingWorldServer((WorldServer)this.field_70331_k, this) : new GrindingWorld(this.field_70331_k, this);
    }

    public Random getRandom() {
        return this._rand;
    }

    @Override
    protected boolean shouldPumpLiquid() {
        return true;
    }

    @Override
    public int getEnergyStoredMax() {
        return 32000;
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 200;
    }

    @Override
    public HarvestAreaManager getHAM() {
        return this._areaManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean activateMachine() {
        boolean bl;
        EntityLivingBase entityLivingBase;
        this._grindingWorld.cleanReferences();
        List list = this.field_70331_k.func_72872_a(EntityLivingBase.class, this._areaManager.getHarvestArea().toAxisAlignedBB());
        Iterator iterator = list.iterator();
        block3: while (true) {
            if (!iterator.hasNext()) {
                this.setIdleTicks(this.getIdleTicksMax());
                return false;
            }
            Object e = iterator.next();
            entityLivingBase = (EntityLivingBase)e;
            if (entityLivingBase instanceof EntityAgeable && ((EntityAgeable)entityLivingBase).func_70874_b() < 0 || entityLivingBase.func_85032_ar() || entityLivingBase.func_110143_aJ() <= 0.0f) continue;
            bl = false;
            if (MFRRegistry.getGrindables().containsKey(entityLivingBase.getClass())) {
                IFactoryGrindable iFactoryGrindable = MFRRegistry.getGrindables().get(entityLivingBase.getClass());
                List<MobDrop> list2 = iFactoryGrindable.grind(entityLivingBase.field_70170_p, entityLivingBase, this.getRandom());
                if (list2 != null && list2.size() > 0 && WeightedRandom.func_76272_a(list2) > 0) {
                    ItemStack itemStack = ((MobDrop)WeightedRandom.func_76271_a((Random)this._rand, list2)).getStack();
                    this.doDrop(itemStack);
                }
                if (iFactoryGrindable.processEntity(entityLivingBase)) {
                    bl = true;
                    if (!(entityLivingBase.func_110143_aJ() <= 0.0f)) break;
                    continue;
                }
            }
            for (Class clazz : MFRRegistry.getGrinderBlacklist()) {
                if (!clazz.isInstance(entityLivingBase)) continue;
                continue block3;
            }
            if (this._grindingWorld.addEntityForGrinding((Entity)entityLivingBase)) break;
        }
        if (bl && entityLivingBase.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            try {
                entityLivingBase.field_70170_p.func_82736_K().func_82764_b("doMobLoot", "false");
                this.damageEntity(entityLivingBase);
                if (!(entityLivingBase.func_110143_aJ() <= 0.0f)) return true;
                this._tank.fill(FluidRegistry.getFluidStack((String)"mobessence", (int)100), true);
                return true;
            }
            finally {
                entityLivingBase.field_70170_p.func_82736_K().func_82764_b("doMobLoot", "true");
                this.setIdleTicks(20);
            }
        }
        this.damageEntity(entityLivingBase);
        if (entityLivingBase.func_110143_aJ() <= 0.0f) {
            this._tank.fill(FluidRegistry.getFluidStack((String)"mobessence", (int)100), true);
            this.setIdleTicks(20);
            return true;
        }
        this.setIdleTicks(10);
        return true;
    }

    protected void setRecentlyHit(EntityLivingBase entityLivingBase, int n) {
        try {
            recentlyHit.set(entityLivingBase, n);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void damageEntity(EntityLivingBase entityLivingBase) {
        this.setRecentlyHit(entityLivingBase, 100);
        entityLivingBase.func_70097_a((DamageSource)this._damageSource, 500000.0f);
    }

    public int func_70302_i_() {
        return 0;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return this._tank.drain(n, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack != null && fluidStack.isFluidEqual(this._tank.getFluid())) {
            return this._tank.drain(fluidStack.amount, bl);
        }
        return null;
    }

    @Override
    public boolean allowBucketDrain() {
        return true;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }

    @Override
    public boolean manageFluids() {
        return true;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    @Override
    public boolean canRotate() {
        return true;
    }

    static {
        String[] stringArray = ObfuscationReflectionHelper.remapFieldNames((String)"net.minecraft.entity.EntityLivingBase", (String[])new String[]{"field_70718_bc", "recentlyHit"});
        recentlyHit = ReflectionHelper.findField(EntityLivingBase.class, (String[])stringArray);
    }
}

