/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.rednet;

import cpw.mods.fml.common.network.PacketDispatcher;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import org.bouncycastle.util.Arrays;
import powercrystals.core.net.PacketWrapper;
import powercrystals.core.position.BlockPosition;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.rednet.IConnectableRedNet;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetLogicCircuit;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetNetworkContainer;
import powercrystals.minefactoryreloaded.circuits.Noop;
import powercrystals.minefactoryreloaded.item.ItemLogicUpgradeCard;

public class TileEntityRedNetLogic
extends TileEntity {
    private int _circuitCount = 6;
    private int _variableCount = 16;
    private IRedNetLogicCircuit[] _circuits = new IRedNetLogicCircuit[this._circuitCount];
    private int[][] _buffers = new int[15][];
    private PinMapping[][] _pinMappingInputs = new PinMapping[this._circuits.length][];
    private PinMapping[][] _pinMappingOutputs = new PinMapping[this._circuits.length][];
    private int[] _upgradeLevel = new int[6];
    public int crafters = 0;

    public TileEntityRedNetLogic() {
        int n;
        for (n = 0; n < 12; ++n) {
            this._buffers[n] = new int[16];
        }
        this._buffers[12] = new int[256];
        this._buffers[13] = new int[this._variableCount];
        this._buffers[14] = new int[1];
        for (n = 0; n < this._circuits.length; ++n) {
            this.initCircuit(n, new Noop());
        }
        for (n = 0; n < 256; ++n) {
            this._buffers[12][n] = n;
        }
    }

    public int getVariableBufferSize() {
        return this._variableCount;
    }

    public int getCircuitCount() {
        return this._circuitCount;
    }

    public int getBufferLength(int n) {
        return this._buffers[n].length;
    }

    public int getVariableValue(int n) {
        return this._buffers[13][n];
    }

    public IRedNetLogicCircuit getCircuit(int n) {
        return this._circuits[n];
    }

    public PinMapping getInputPinMapping(int n, int n2) {
        return this._pinMappingInputs[n][n2];
    }

    public void setInputPinMapping(int n, int n2, int n3, int n4) {
        this._pinMappingInputs[n][n2] = new PinMapping(n4, n3);
    }

    public PinMapping getOutputPinMapping(int n, int n2) {
        return this._pinMappingOutputs[n][n2];
    }

    public void setOutputPinMapping(int n, int n2, int n3, int n4) {
        this._pinMappingOutputs[n][n2] = new PinMapping(n4, n3);
    }

    private IRedNetLogicCircuit getNewCircuit(String string) {
        try {
            return (IRedNetLogicCircuit)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new Noop();
        }
    }

    public void initCircuit(int n, String string) {
        this.initCircuit(n, this.getNewCircuit(string));
    }

    private void initCircuit(int n, IRedNetLogicCircuit iRedNetLogicCircuit) {
        int n2;
        this._circuits[n] = iRedNetLogicCircuit;
        this._pinMappingInputs[n] = this._pinMappingInputs[n] == null ? new PinMapping[this._circuits[n].getInputCount()] : java.util.Arrays.copyOf(this._pinMappingInputs[n], this._circuits[n].getInputCount());
        this._pinMappingOutputs[n] = this._pinMappingOutputs[n] == null ? new PinMapping[this._circuits[n].getOutputCount()] : java.util.Arrays.copyOf(this._pinMappingOutputs[n], this._circuits[n].getOutputCount());
        for (n2 = 0; n2 < this._pinMappingInputs[n].length; ++n2) {
            if (this._pinMappingInputs[n][n2] != null) continue;
            this._pinMappingInputs[n][n2] = new PinMapping(0, 12);
        }
        for (n2 = 0; n2 < this._pinMappingOutputs[n].length; ++n2) {
            if (this._pinMappingOutputs[n][n2] != null) continue;
            this._pinMappingOutputs[n][n2] = new PinMapping(0, 14);
        }
    }

    public void reinitialize(EntityPlayer entityPlayer) {
        int n;
        for (n = 0; n < this._upgradeLevel.length; ++n) {
            if (this._upgradeLevel[n] <= 0) continue;
            ItemStack itemStack = new ItemStack(MineFactoryReloadedCore.logicCardItem.field_77779_bT, 1, this._upgradeLevel[n] - 1);
            if (!entityPlayer.field_71071_by.func_70441_a(itemStack)) {
                entityPlayer.func_70099_a(itemStack, 0.0f);
            }
            this._upgradeLevel[n] = 0;
        }
        this.updateUpgradeLevels();
        for (n = 0; n < this._circuits.length; ++n) {
            this.initCircuit(n, new Noop());
            this.sendCircuitDefinition(n);
        }
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void setCircuitFromPacket(DataInputStream dataInputStream) {
        try {
            int n;
            int n2;
            int n3;
            int n4 = dataInputStream.readInt();
            String string = dataInputStream.readUTF();
            this.initCircuit(n4, string);
            int n5 = dataInputStream.readInt();
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = dataInputStream.readInt();
                n = dataInputStream.readInt();
                this._pinMappingInputs[n4][n3] = new PinMapping(n, n2);
            }
            n3 = dataInputStream.readInt();
            for (n2 = 0; n2 < n3; ++n2) {
                n = dataInputStream.readInt();
                int n6 = dataInputStream.readInt();
                this._pinMappingOutputs[n4][n2] = new PinMapping(n6, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void sendCircuitDefinition(int n) {
        int n2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.field_70329_l);
        arrayList.add(this.field_70330_m);
        arrayList.add(this.field_70327_n);
        arrayList.add(n);
        arrayList.add(this._circuits[n].getClass().getName());
        arrayList.add(this._circuits[n].getInputCount());
        for (n2 = 0; n2 < this._pinMappingInputs[n].length; ++n2) {
            arrayList.add(this._pinMappingInputs[n][n2].buffer);
            arrayList.add(this._pinMappingInputs[n][n2].pin);
        }
        arrayList.add(this._circuits[n].getOutputCount());
        for (n2 = 0; n2 < this._pinMappingOutputs[n].length; ++n2) {
            arrayList.add(this._pinMappingOutputs[n][n2].buffer);
            arrayList.add(this._pinMappingOutputs[n][n2].pin);
        }
        PacketDispatcher.sendPacketToAllAround((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)5.0, (int)this.field_70331_k.field_73011_w.field_76574_g, (Packet)PacketWrapper.createPacket((String)"MFReloaded", (int)12, (Object[])arrayList.toArray()));
    }

    public void func_70316_g() {
        Object object;
        Object object2;
        int n;
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        int[][] nArrayArray = new int[6][];
        for (n = 0; n < 6; ++n) {
            nArrayArray[n] = this._buffers[n + 6];
            this._buffers[n + 6] = new int[16];
        }
        for (n = 0; n < this._circuits.length; ++n) {
            if (this._circuits[n] instanceof Noop) continue;
            object2 = new int[this._circuits[n].getInputCount()];
            for (int i = 0; i < ((int[])object2).length; ++i) {
                object2[i] = this._buffers[this._pinMappingInputs[n][i].buffer][this._pinMappingInputs[n][i].pin];
            }
            object = this._circuits[n].recalculateOutputValues(this.field_70331_k.func_82737_E(), (int[])object2);
            for (int i = 0; i < ((int[])object).length; ++i) {
                this._buffers[this._pinMappingOutputs[n][i].buffer][this._pinMappingOutputs[n][i].pin] = object[i];
            }
        }
        for (n = 0; n < 6; ++n) {
            if (Arrays.areEqual((int[])nArrayArray[n], (int[])this._buffers[n + 6])) continue;
            object2 = new BlockPosition((TileEntity)this);
            object2.orientation = ForgeDirection.VALID_DIRECTIONS[n];
            object2.moveForwards(1);
            object = Block.field_71973_m[this.field_70331_k.func_72798_a(object2.x, object2.y, object2.z)];
            if (object instanceof IRedNetNetworkContainer) {
                ((IRedNetNetworkContainer)object).updateNetwork(this.field_70331_k, object2.x, object2.y, object2.z);
                continue;
            }
            if (!(object instanceof IConnectableRedNet)) continue;
            ((IConnectableRedNet)object).onInputsChanged(this.field_70331_k, object2.x, object2.y, object2.z, object2.orientation.getOpposite(), this._buffers[n + 6]);
        }
    }

    public int getOutputValue(ForgeDirection forgeDirection, int n) {
        return this.getOutputValues(forgeDirection)[n];
    }

    public int[] getOutputValues(ForgeDirection forgeDirection) {
        if (forgeDirection == ForgeDirection.UNKNOWN) {
            return null;
        }
        return this._buffers[forgeDirection.ordinal() + 6];
    }

    public void onInputsChanged(ForgeDirection forgeDirection, int[] nArray) {
        if (forgeDirection != ForgeDirection.UNKNOWN) {
            this._buffers[forgeDirection.ordinal()] = nArray;
        }
    }

    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        super.func_70310_b(nBTTagCompound);
        NBTTagList nBTTagList = new NBTTagList();
        for (int i = 0; i < this._circuits.length; ++i) {
            NBTTagCompound nBTTagCompound2;
            NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
            nBTTagCompound3.func_74778_a("circuit", this._circuits[i].getClass().getName());
            NBTTagList nBTTagList2 = new NBTTagList();
            for (int j = 0; j < this._pinMappingInputs[i].length; ++j) {
                nBTTagCompound2 = new NBTTagCompound();
                nBTTagCompound2.func_74768_a("buffer", this._pinMappingInputs[i][j].buffer);
                nBTTagCompound2.func_74768_a("pin", this._pinMappingInputs[i][j].pin);
                nBTTagList2.func_74742_a((NBTBase)nBTTagCompound2);
            }
            nBTTagCompound3.func_74782_a("inputPins", (NBTBase)nBTTagList2);
            NBTTagList nBTTagList3 = new NBTTagList();
            for (int j = 0; j < this._pinMappingOutputs[i].length; ++j) {
                NBTTagCompound nBTTagCompound4 = new NBTTagCompound();
                nBTTagCompound4.func_74768_a("buffer", this._pinMappingOutputs[i][j].buffer);
                nBTTagCompound4.func_74768_a("pin", this._pinMappingOutputs[i][j].pin);
                nBTTagList3.func_74742_a((NBTBase)nBTTagCompound4);
            }
            nBTTagCompound3.func_74782_a("outputPins", (NBTBase)nBTTagList3);
            nBTTagCompound2 = new NBTTagCompound();
            this._circuits[i].writeToNBT(nBTTagCompound2);
            nBTTagCompound3.func_74782_a("state", (NBTBase)nBTTagCompound2);
            nBTTagList.func_74742_a((NBTBase)nBTTagCompound3);
        }
        nBTTagCompound.func_74782_a("circuits", (NBTBase)nBTTagList);
        nBTTagCompound.func_74783_a("upgrades", this._upgradeLevel);
        nBTTagCompound.func_74783_a("vars", this._buffers[13]);
    }

    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        super.func_70307_a(nBTTagCompound);
        int[] nArray = nBTTagCompound.func_74759_k("upgrades");
        if (nArray != null && nArray.length == this._upgradeLevel.length) {
            this._upgradeLevel = nArray;
        }
        this.updateUpgradeLevels();
        int[] nArray2 = nBTTagCompound.func_74759_k("vars");
        if (nArray2 != null && nArray2.length == this._buffers[13].length) {
            this._buffers[13] = nArray2;
        }
        this.readCircuitsOnly(nBTTagCompound);
    }

    public void readCircuitsOnly(NBTTagCompound nBTTagCompound) {
        NBTTagList nBTTagList = nBTTagCompound.func_74761_m("circuits");
        if (nBTTagList != null) {
            for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
                NBTTagCompound nBTTagCompound2;
                NBTTagList nBTTagList2;
                int n;
                int n2;
                this.initCircuit(i, ((NBTTagCompound)nBTTagList.func_74743_b(i)).func_74779_i("circuit"));
                NBTTagList nBTTagList3 = ((NBTTagCompound)nBTTagList.func_74743_b(i)).func_74761_m("inputPins");
                if (nBTTagList3 != null) {
                    for (int j = 0; j < nBTTagList3.func_74745_c() && j < this._pinMappingInputs[i].length; ++j) {
                        n2 = ((NBTTagCompound)nBTTagList3.func_74743_b(j)).func_74762_e("pin");
                        n = ((NBTTagCompound)nBTTagList3.func_74743_b(j)).func_74762_e("buffer");
                        this._pinMappingInputs[i][j] = new PinMapping(n2, n);
                    }
                }
                if ((nBTTagList2 = ((NBTTagCompound)nBTTagList.func_74743_b(i)).func_74761_m("outputPins")) != null) {
                    for (n2 = 0; n2 < nBTTagList2.func_74745_c() && n2 < this._pinMappingOutputs[i].length; ++n2) {
                        n = ((NBTTagCompound)nBTTagList2.func_74743_b(n2)).func_74762_e("pin");
                        int n3 = ((NBTTagCompound)nBTTagList2.func_74743_b(n2)).func_74762_e("buffer");
                        this._pinMappingOutputs[i][n2] = new PinMapping(n, n3);
                    }
                }
                if ((nBTTagCompound2 = ((NBTTagCompound)nBTTagList.func_74743_b(i)).func_74775_l("state")) == null) continue;
                this._circuits[i].readFromNBT(nBTTagCompound2);
            }
        }
    }

    public Packet func_70319_e() {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74783_a("upgrades", this._upgradeLevel);
        Packet132TileEntityData packet132TileEntityData = new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, nBTTagCompound);
        return packet132TileEntityData;
    }

    public void onDataPacket(INetworkManager iNetworkManager, Packet132TileEntityData packet132TileEntityData) {
        this._upgradeLevel = packet132TileEntityData.field_73331_e.func_74759_k("upgrades");
        this.updateUpgradeLevels();
    }

    public boolean insertUpgrade(int n) {
        for (int i = 0; i < 6; ++i) {
            if (this._upgradeLevel[i] != 0) continue;
            if (!this.field_70331_k.field_72995_K) {
                this._upgradeLevel[i] = n;
                this.updateUpgradeLevels();
            }
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            return true;
        }
        return false;
    }

    public void setUpgrade(int n, int n2) {
        this._upgradeLevel[n] = n2;
    }

    public int getLevelForSlot(int n) {
        return this._upgradeLevel[n];
    }

    private void updateUpgradeLevels() {
        int n;
        int n2 = 6;
        int n3 = 16;
        for (int i = 0; i < this._upgradeLevel.length; ++i) {
            n2 += ItemLogicUpgradeCard.getCircuitsForLevel(this._upgradeLevel[i]);
            n3 += ItemLogicUpgradeCard.getVariablesForLevel(this._upgradeLevel[i]);
        }
        this._circuitCount = n2;
        this._variableCount = n3;
        this._circuits = java.util.Arrays.copyOf(this._circuits, this._circuitCount);
        this._buffers[13] = Arrays.copyOf((int[])this._buffers[13], (int)this._variableCount);
        PinMapping[][] pinMappingArrayArray = new PinMapping[this._circuitCount][];
        for (int i = 0; i < pinMappingArrayArray.length; ++i) {
            if (i >= this._pinMappingInputs.length || this._pinMappingInputs[i] == null) continue;
            pinMappingArrayArray[i] = this._pinMappingInputs[i];
        }
        this._pinMappingInputs = pinMappingArrayArray;
        PinMapping[][] pinMappingArrayArray2 = new PinMapping[this._circuitCount][];
        for (n = 0; n < pinMappingArrayArray2.length; ++n) {
            if (n >= this._pinMappingOutputs.length || this._pinMappingOutputs[n] == null) continue;
            pinMappingArrayArray2[n] = this._pinMappingOutputs[n];
        }
        this._pinMappingOutputs = pinMappingArrayArray2;
        for (n = 0; n < this._circuits.length; ++n) {
            if (this._circuits[n] != null) continue;
            this.initCircuit(n, new Noop());
        }
    }

    public class PinMapping {
        public int pin;
        public int buffer;

        public PinMapping(int n, int n2) {
            this.pin = n;
            this.buffer = n2;
        }
    }
}

