/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop;

import ic2.api.crops.CropCard;
import ic2.api.crops.ICropTile;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;

public class CropVenomilia
extends CropCard {
    @Override
    public String name() {
        return "Venomilia";
    }

    @Override
    public String discoveredBy() {
        return "raGan";
    }

    @Override
    public int tier() {
        return 3;
    }

    @Override
    public int stat(int n) {
        switch (n) {
            case 0: {
                return 3;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 3;
            }
        }
        return 0;
    }

    @Override
    public String[] attributes() {
        return new String[]{"Purple", "Flower", "Tulip", "Poison"};
    }

    @Override
    public int maxSize() {
        return 6;
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        return crop.getSize() <= 4 && crop.getLightLevel() >= 12 || crop.getSize() == 5;
    }

    @Override
    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() >= 4;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        if (crop.getSize() == 5) {
            return new ItemStack(Ic2Items.grinPowder.func_77973_b(), 1);
        }
        if (crop.getSize() >= 4) {
            return new ItemStack(Item.field_77756_aW, 1, 5);
        }
        return null;
    }

    @Override
    public byte getSizeAfterHarvest(ICropTile crop) {
        return 3;
    }

    @Override
    public int growthDuration(ICropTile crop) {
        if (crop.getSize() >= 3) {
            return 600;
        }
        return 400;
    }

    @Override
    public boolean rightclick(ICropTile crop, EntityPlayer player) {
        if (!player.func_70093_af()) {
            this.onEntityCollision(crop, (Entity)player);
        }
        return crop.harvest(true);
    }

    @Override
    public boolean leftclick(ICropTile crop, EntityPlayer player) {
        if (!player.func_70093_af()) {
            this.onEntityCollision(crop, (Entity)player);
        }
        return crop.pick(true);
    }

    @Override
    public boolean onEntityCollision(ICropTile crop, Entity entity) {
        if (crop.getSize() == 5 && entity instanceof EntityLivingBase) {
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_70093_af() && IC2.random.nextInt(50) != 0) {
                return super.onEntityCollision(crop, entity);
            }
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, (IC2.random.nextInt(10) + 5) * 20, 0));
            crop.setSize((byte)4);
            crop.updateState();
        }
        return super.onEntityCollision(crop, entity);
    }

    @Override
    public boolean isWeed(ICropTile crop) {
        return crop.getSize() == 5 && crop.getGrowth() >= 8;
    }
}

