=begin
[i]TIG (c) 2015[/i]  

All rights reserved.    

**TIG-LayersFromList.rb**  

#Installation:  

Suitable for SketchUp Versions >= 2014...  
The RB file goes in the Plugins folder [restart Sketchup].   
Or much easier, no restart required !  
Use the Preferences > Extensions > Install button... on the RBZ archive.  

#Overview:  

A tool to read data from a file and from that add/change Layers by name  
and/or change the Layers' Colors.  

[i]Plugins|Extensions > TIG-LayersFromList[/i]  

Make a file with a line for each Layer Name and Color, in the format:  

[i]LayerName:R,G,B[/i]  

The ":" is the separator between the Layer's Name and its R,G,B values.  
Note that if you do have ":" elsewhere in the Layer's Name it will still work.   
You can change this separator by editing the .RB file at:  
  @separator = ":"  
To include another string inside the "".  

The R,G,B Color values are separated by commas, and are integers 0 to 255.  
These represent the Red, Green, Blue values - the higher the number the more  
of that hue in the Color.  
Note that the Layer Color's 'A' alpha-transparency is not accessible for in the  
Ruby API, but it can be done manually by editing the Layer's Color in the  
Layer Browser.  

The file may be a plain text file of any name - obviously give it something  
that is meaningful to you, e.g. "MyNewLayers.txt"  

Now run the tool...  

Chose the file and it is processed...  
Layers are made if needed.  
The Layer's color is changed to the R,G,B values in the file.  
If no R,G,B is given, then a random color is assigned to the Layer,  
or if it is existing, then its color is reused.  
If an existing Layer is not listed in the file, then that is left unchanged.  

The operation is one step undo-able.  


Version:  

1.0 20150507 First issue.  
1.1 20150508 A ":" is now used as the Name separator.  

=end
###
require('sketchup.rb')
###
module TIG
	module LayersFromList
		### edit the layerName:R,G,B separator here...
		@separator = ":"
		### menu
		unless file_loaded?(__FILE__)
			UI.menu("Plugins").add_item("TIG-LayersFromList"){ self.new() }
			file_loaded(__FILE__)
		end
		###
		def self.new()
			unless Sketchup.version.to_i >= 14
				UI.messagebox("TIG-LayersFromList: Only works with SketchUp >= v2014 !")
				return nil
			end
			model = Sketchup.active_model
			layers = model.layers
			file = UI.openpanel("TIG-LayersFromList: Choose File...", "", "")
			return nil unless file
		   model.start_operation("TIG-LayersFromList", true)
		    lines = IO.readlines(file)
			lines.each{|line|
				line.chomp!
				next if line.empty?
				pts = line.split(@separator)
				if pts.length > 2
					nam = ""
					if line =~ /[,][0-2]/
						npts = pts[0..-2]
					else
						npts = pts
					end
					npts.each_with_index{|e, i|
						if i == npts.length-1
							nam << e
						else
							nam << e+":"
						end
					}
				else
					nam = pts[0]
				end
				next if nam.empty?
				layer = layers.add(nam)
				rgb = pts[-1]
				if rgb
					col = rgb.split(",")
					r = col[0]
					g = col[1]
					b = col[2]
					if b
						r = r.to_i
						r = 0 if r < 0
						r = 255 if r > 255
						g = g.to_i
						g = 0 if g < 0
						g = 255 if g > 255
						b = b.to_i
						b = 0 if b < 0
						b = 255 if b > 255
						color = Sketchup::Color.new(r, g, b)
						layer.color = color
					end
				end
			}
		   model.commit_operation
		end
		###
	end
end#TIG
